"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryFlyout = exports.default = exports.LogEntryFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _log_entry = require("../../../containers/logs/log_entry");
var _centered_flyout_body = require("../../centered_flyout_body");
var _data_search_error_callout = require("../../data_search_error_callout");
var _data_search_progress = require("../../data_search_progress");
var _log_entry_actions_menu = require("./log_entry_actions_menu");
var _log_entry_fields_table = require("./log_entry_fields_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/logs_shared/public/components/logging/log_entry_flyout/log_entry_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useLogEntryFlyout = logViewReference => {
  const flyoutRef = (0, _react.useRef)();
  const {
    services: {
      http,
      data,
      share,
      uiSettings,
      application,
      logsShared
    },
    overlays: {
      openFlyout
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const closeLogEntryFlyout = (0, _react.useCallback)(() => {
    var _flyoutRef$current;
    (_flyoutRef$current = flyoutRef.current) === null || _flyoutRef$current === void 0 ? void 0 : _flyoutRef$current.close();
  }, []);
  const openLogEntryFlyout = (0, _react.useCallback)(logEntryId => {
    const {
      Provider: KibanaReactContextProvider
    } = (0, _public.createKibanaReactContext)({
      http,
      data,
      share,
      uiSettings,
      application,
      logsShared
    });
    flyoutRef.current = openFlyout(/*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(LogEntryFlyout, {
      logEntryId: logEntryId,
      onCloseFlyout: closeLogEntryFlyout,
      logViewReference: logViewReference,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    })));
  }, [logsShared, application, closeLogEntryFlyout, data, http, logViewReference, openFlyout, share, uiSettings]);
  (0, _react.useEffect)(() => {
    return () => {
      closeLogEntryFlyout();
    };
  }, [closeLogEntryFlyout]);
  return {
    openLogEntryFlyout,
    closeLogEntryFlyout
  };
};
exports.useLogEntryFlyout = useLogEntryFlyout;
const LogEntryFlyout = ({
  logEntryId,
  onCloseFlyout,
  onSetFieldFilter,
  logViewReference
}) => {
  var _logEntryErrors$lengt;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    cancelRequest: cancelLogEntryRequest,
    errors: logEntryErrors,
    fetchLogEntry,
    isRequestRunning,
    loaded: logEntryRequestProgress,
    logEntry,
    total: logEntryRequestTotal
  } = (0, _log_entry.useLogEntry)({
    logViewReference,
    logEntryId
  });
  const {
    services: {
      logsShared: {
        LogAIAssistant
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _react.useEffect)(() => {
    if (logViewReference && logEntryId) {
      fetchLogEntry();
    }
  }, [fetchLogEntry, logViewReference, logEntryId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCloseFlyout,
    size: "m",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Details for log entry {logEntryId}",
    id: "xpack.logsShared.logFlyout.flyoutTitle",
    values: {
      logEntryId: logEntryId ? /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 46
        }
      }, logEntryId) : ''
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }))), logEntry ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logFlyout.flyoutSubTitle",
    defaultMessage: "From index {indexName}",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 34
        }
      }, logEntry.index)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 19
    }
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      padding: 8
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, logEntry ? /*#__PURE__*/_react.default.createElement(_log_entry_actions_menu.LogEntryActionsMenu, {
    logEntry: logEntry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 25
    }
  }) : null))), isRequestRunning ? /*#__PURE__*/_react.default.createElement(_centered_flyout_body.CenteredEuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '75%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_data_search_progress.DataSearchProgress, {
    label: loadingProgressMessage,
    maxValue: logEntryRequestTotal,
    onCancel: cancelLogEntryRequest,
    value: logEntryRequestProgress,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }))) : logEntry ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: ((_logEntryErrors$lengt = logEntryErrors === null || logEntryErrors === void 0 ? void 0 : logEntryErrors.length) !== null && _logEntryErrors$lengt !== void 0 ? _logEntryErrors$lengt : 0) > 0 ? /*#__PURE__*/_react.default.createElement(_data_search_error_callout.DataSearchErrorCallout, {
      title: loadingErrorCalloutTitle,
      errors: logEntryErrors !== null && logEntryErrors !== void 0 ? logEntryErrors : [],
      onRetry: fetchLogEntry,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, LogAIAssistant && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(LogAIAssistant, {
    doc: logEntry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_log_entry_fields_table.LogEntryFieldsTable, {
    logEntry: logEntry,
    onSetFieldFilter: onSetFieldFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  })))) : /*#__PURE__*/_react.default.createElement(_centered_flyout_body.CenteredEuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '75%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_data_search_error_callout.DataSearchErrorCallout, {
    title: loadingErrorCalloutTitle,
    errors: logEntryErrors !== null && logEntryErrors !== void 0 ? logEntryErrors : [],
    onRetry: fetchLogEntry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.LogEntryFlyout = LogEntryFlyout;
var _default = exports.default = LogEntryFlyout;
const loadingProgressMessage = _i18n.i18n.translate('xpack.logsShared.logFlyout.loadingMessage', {
  defaultMessage: 'Searching log entry in shards'
});
const loadingErrorCalloutTitle = _i18n.i18n.translate('xpack.logsShared.logFlyout.loadingErrorCalloutTitle', {
  defaultMessage: 'Error while searching the log entry'
});