"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkEditor = void 0;
var _uuid = require("uuid");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _content_management = require("../../../common/content_management");
var _links_strings = require("../links_strings");
var _constants = require("./constants");
var _link_options = require("./link_options");
var _link_destination = require("./link_destination");
var _get_options = require("../../../common/embeddable/transforms/get_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/editor/link_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinkEditor = ({
  link,
  onSave,
  onClose,
  parentDashboardId
}) => {
  var _link$type, _link$label;
  const [selectedLinkType, setSelectedLinkType] = (0, _react.useState)((_link$type = link === null || link === void 0 ? void 0 : link.type) !== null && _link$type !== void 0 ? _link$type : _content_management.DASHBOARD_LINK_TYPE);
  const [defaultLinkLabel, setDefaultLinkLabel] = (0, _react.useState)(link === null || link === void 0 ? void 0 : link.title);
  const [currentLinkLabel, setCurrentLinkLabel] = (0, _react.useState)((_link$label = link === null || link === void 0 ? void 0 : link.label) !== null && _link$label !== void 0 ? _link$label : '');
  const [linkDescription, setLinkDescription] = (0, _react.useState)(link === null || link === void 0 ? void 0 : link.description);
  const [linkOptions, setLinkOptions] = (0, _react.useState)(link === null || link === void 0 ? void 0 : link.options);
  const [linkDestination, setLinkDestination] = (0, _react.useState)(link === null || link === void 0 ? void 0 : link.destination);
  const linkTypes = (0, _react.useMemo)(() => {
    return [_content_management.DASHBOARD_LINK_TYPE, _content_management.EXTERNAL_LINK_TYPE].map(type => {
      return {
        id: type,
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          "aria-label": _constants.LinkInfo[type].description,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: _constants.LinkInfo[type].icon,
          color: "text",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 13
          }
        }, _constants.LinkInfo[type].displayName)),
        'data-test-subj': `links--linkEditor--${type}--radioBtn`
      };
    });
  }, []);

  /** When a new destination is picked, handle the logic for what to display as the current + default labels */
  const handleDestinationPicked = (0, _react.useCallback)((destination, label, description) => {
    setLinkDestination(destination);
    if (!currentLinkLabel || defaultLinkLabel === currentLinkLabel) {
      setCurrentLinkLabel(label !== null && label !== void 0 ? label : '');
    }
    setDefaultLinkLabel(label);
    setLinkDescription(description);
  }, [defaultLinkLabel, currentLinkLabel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    className: 'linkEditor in',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "linkEditorBackButton",
    flush: "left",
    color: "text",
    iconType: 'arrowLeft',
    onClick: () => onClose(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "aria-label": _links_strings.LinksStrings.editor.linkEditor.getGoBackAriaLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, link ? _links_strings.LinksStrings.editor.getEditLinkTitle() : _links_strings.LinksStrings.editor.getAddButtonLabel())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "links--linkEditor--flyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkTypePickerLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    compressed: true,
    options: linkTypes,
    idSelected: selectedLinkType,
    onChange: id => {
      if (currentLinkLabel === defaultLinkLabel) {
        var _link$label2;
        setCurrentLinkLabel((link === null || link === void 0 ? void 0 : link.type) === id ? (_link$label2 = link.label) !== null && _link$label2 !== void 0 ? _link$label2 : '' : '');
      }
      setSelectedLinkType(id);
    },
    name: "linkType",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_link_destination.LinkDestination, {
    link: link,
    parentDashboardId: parentDashboardId,
    selectedLinkType: selectedLinkType,
    setDestination: handleDestinationPicked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkTextLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    placeholder: (linkDestination ? defaultLinkLabel : '') || _links_strings.LinksStrings.editor.linkEditor.getLinkTextPlaceholder(),
    value: currentLinkLabel,
    onChange: e => setCurrentLinkLabel(e.target.value),
    "data-test-subj": "links--linkEditor--linkLabel--input",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_link_options.LinkOptionsComponent, {
    link: link,
    setLinkOptions: setLinkOptions,
    selectedLinkType: selectedLinkType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    onClick: () => onClose(),
    "data-test-subj": "links--linkEditor--closeBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }, _links_strings.LinksStrings.editor.getCancelButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !linkDestination,
    onClick: () => {
      // this check should always be true, since the button is disabled otherwise - this is just for type safety
      if (linkDestination) {
        var _link$id;
        onSave({
          label: currentLinkLabel === defaultLinkLabel ? undefined : currentLinkLabel,
          type: selectedLinkType,
          id: (_link$id = link === null || link === void 0 ? void 0 : link.id) !== null && _link$id !== void 0 ? _link$id : (0, _uuid.v4)(),
          destination: linkDestination,
          options: (0, _get_options.getOptions)(selectedLinkType, linkOptions),
          title: defaultLinkLabel !== null && defaultLinkLabel !== void 0 ? defaultLinkLabel : '',
          description: linkDescription
        });
        onClose();
      }
    },
    "data-test-subj": "links--linkEditor--saveBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, link ? _links_strings.LinksStrings.editor.getUpdateButtonLabel() : _links_strings.LinksStrings.editor.getAddButtonLabel())))));
};
exports.LinkEditor = LinkEditor;