"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryOptIn = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/telemetry-management-section-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/license_management/public/application/components/telemetry_opt_in/telemetry_opt_in.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  licManagementNarrowText: (0, _react2.css)`
    width: 240px;
  `
};
class TelemetryOptIn extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showMoreTelemetryInfo: false,
      showExample: false
    });
    (0, _defineProperty2.default)(this, "closeReadMorePopover", () => {
      this.setState({
        showMoreTelemetryInfo: false
      });
    });
    (0, _defineProperty2.default)(this, "onClickReadMore", () => {
      const {
        showMoreTelemetryInfo
      } = this.state;
      this.setState({
        showMoreTelemetryInfo: !showMoreTelemetryInfo
      });
    });
    (0, _defineProperty2.default)(this, "onClickExample", () => {
      this.setState({
        showExample: true
      });
      this.closeReadMorePopover();
    });
    (0, _defineProperty2.default)(this, "onChangeOptIn", event => {
      const isOptingInToTelemetry = event.target.checked;
      const {
        onOptInChange
      } = this.props;
      onOptInChange(isOptingInToTelemetry);
    });
  }
  render() {
    const {
      showMoreTelemetryInfo,
      showExample
    } = this.state;
    const {
      isStartTrial,
      isOptingInToTelemetry,
      telemetry
    } = this.props;
    let example = null;
    if (showExample) {
      // Using React.Suspense and lazy loading here to avoid crashing the plugin when importing
      // OptInExampleFlyout but telemetryManagementSection is disabled
      example = /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
        fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 35
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_public.LazyOptInExampleFlyout, {
        onClose: () => this.setState({
          showExample: false
        }),
        fetchExample: telemetry.telemetryService.fetchExample,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }));
    }
    let toCurrentCustomers;
    if (!isStartTrial) {
      toCurrentCustomers = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h4", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.telemetryOptIn.customersHelpSupportDescription",
        defaultMessage: "Help Elastic support provide better service",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 11
        }
      }));
    }
    const readMoreButton = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.onClickReadMore,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.telemetryOptIn.readMoreLinkText",
      defaultMessage: "Read more",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }));
    const popover = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      ownFocus: true,
      id: "readMorePopover",
      button: readMoreButton,
      isOpen: showMoreTelemetryInfo,
      closePopover: this.closeReadMorePopover,
      className: "eui-AlignBaseline",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: styles.licManagementNarrowText,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.telemetryOptIn.featureUsageWarningMessage",
      defaultMessage: "This feature periodically sends basic feature usage statistics. This information will not be shared outside of Elastic. See an {exampleLink} or read our {telemetryPrivacyStatementLink}. You can disable this feature any time.",
      values: {
        exampleLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: this.onClickExample,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.telemetryOptIn.exampleLinkText",
          defaultMessage: "example",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 129,
            columnNumber: 21
          }
        })),
        telemetryPrivacyStatementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: telemetry.telemetryConstants.getPrivacyStatementUrl(),
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.telemetryOptIn.telemetryPrivacyStatementLinkText",
          defaultMessage: "telemetry privacy statement",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 21
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    }, example, toCurrentCustomers, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      label: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.telemetryOptIn.sendBasicFeatureStatisticsLabel",
        defaultMessage: "Send basic feature usage statistics to Elastic periodically. {popover}",
        values: {
          popover
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 15
        }
      })),
      id: "isOptingInToTelemetry",
      checked: isOptingInToTelemetry,
      onChange: this.onChangeOptIn,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }));
  }
}
exports.TelemetryOptIn = TelemetryOptIn;