"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensSavedObjectSchemaV0 = exports.lensItemSchemaV0 = exports.lensItemDataSchemaV0 = exports.lensItemAttributesSchemaV0 = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Pre-existing Lens SO attributes (aka `v0`).
 *
 * We could still require handling see these attributes and should allow
 * saving them as is with unknown version. The CM will eventually apply the transforms.
 *
 * @deprecated - use `v1` schemas
 */
const lensItemAttributesSchemaV0 = exports.lensItemAttributesSchemaV0 = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  visualizationType: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  state: _configSchema.schema.maybe(_configSchema.schema.any()),
  uiStateJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
  visState: _configSchema.schema.maybe(_configSchema.schema.string()),
  savedSearchRefName: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'ignore'
});

/**
 * The underlying SO type used to store Lens state in Content Management.
 *
 * Only used in lens server-side Content Management.
 *
 * @deprecated - use `v1` schemas
 */
const lensSavedObjectSchemaV0 = exports.lensSavedObjectSchemaV0 = (0, _contentManagementUtils.savedObjectSchema)(lensItemAttributesSchemaV0);

/**
 * The Lens item data returned from the server
 *
 * @deprecated - use `v1` schemas
 */
const lensItemSchemaV0 = exports.lensItemSchemaV0 = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(lensSavedObjectSchemaV0.getPropSchemas(), ['id', 'references']),
  // Spread attributes at root
  ...lensSavedObjectSchemaV0.getPropSchemas().attributes.getPropSchemas()
}, {
  unknowns: 'forbid'
});
const lensItemDataSchemaV0 = exports.lensItemDataSchemaV0 = lensItemSchemaV0.extends({
  id: undefined
});