"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.axisConfig = exports.XyAxisSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _chartIcons = require("@kbn/chart-icons");
var _visualizationUtils = require("@kbn/visualization-utils");
var _shared_components = require("../../../shared_components");
var _helpers = require("../../../shared_components/axis/extent/helpers");
var _axis_extent_settings = require("../../../shared_components/axis/extent/axis_extent_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/toolbar/axis_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const axisConfig = (axis, isHorizontal) => {
  switch (axis) {
    case 'yLeft':
      return {
        icon: isHorizontal ? _chartIcons.EuiIconAxisBottom : _chartIcons.EuiIconAxisLeft,
        groupPosition: 'left',
        popoverTitle: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.bottomAxisLabel', {
          defaultMessage: 'Bottom axis'
        }) : _i18n.i18n.translate('xpack.lens.xyChart.leftAxisLabel', {
          defaultMessage: 'Left axis'
        }),
        buttonDataTestSubj: 'lnsLeftAxisButton'
      };
    case 'yRight':
      return {
        icon: isHorizontal ? _chartIcons.EuiIconAxisTop : _chartIcons.EuiIconAxisRight,
        groupPosition: 'right',
        popoverTitle: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.topAxisLabel', {
          defaultMessage: 'Top axis'
        }) : _i18n.i18n.translate('xpack.lens.xyChart.rightAxisLabel', {
          defaultMessage: 'Right axis'
        }),
        buttonDataTestSubj: 'lnsRightAxisButton'
      };
    case 'x':
    default:
      return {
        icon: isHorizontal ? _chartIcons.EuiIconAxisLeft : _chartIcons.EuiIconAxisBottom,
        groupPosition: 'center',
        popoverTitle: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.leftAxisLabel', {
          defaultMessage: 'Left axis'
        }) : _i18n.i18n.translate('xpack.lens.xyChart.bottomAxisLabel', {
          defaultMessage: 'Bottom axis'
        }),
        buttonDataTestSubj: 'lnsBottomAxisButton'
      };
  }
};
exports.axisConfig = axisConfig;
const XyAxisSettings = ({
  axis,
  axisTitle,
  updateTitleState,
  toggleTickLabelsVisibility,
  toggleGridlinesVisibility,
  areTickLabelsVisible,
  areGridlinesVisible,
  isTitleVisible,
  orientation,
  setOrientation,
  setEndzoneVisibility,
  endzonesVisible,
  setCurrentTimeMarkerVisibility,
  currentTimeMarkerVisible,
  extent,
  setExtent,
  hasBarOrAreaOnAxis,
  hasPercentageAxis,
  dataBounds,
  useMultilayerTimeAxis,
  scale,
  setScale,
  setScaleWithExtent
}) => {
  const onExtentChange = (0, _react.useCallback)(newExtent => {
    if (setExtent && newExtent && !(0, _lodash.isEqual)(newExtent, extent)) {
      const {
        errorMsg
      } = (0, _helpers.validateExtent)(hasBarOrAreaOnAxis, newExtent, scale);
      if (axis === 'x' || newExtent.mode !== 'custom' || !errorMsg) {
        setExtent(newExtent);
      }
    }
  }, [setExtent, extent, hasBarOrAreaOnAxis, scale, axis]);
  const {
    inputValue: localExtent,
    handleInputChange: setLocalExtent
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: extent,
    onChange: onExtentChange
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarTitleSettings, {
    settingId: axis,
    title: axisTitle,
    updateTitleState: title => updateTitleState(title, axis),
    isTitleVisible: isTitleVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.Gridlines', {
      defaultMessage: 'Gridlines'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": `lnsshow${axis}AxisGridlines`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.Gridlines', {
      defaultMessage: 'Gridlines'
    }),
    onChange: () => toggleGridlinesVisibility(axis),
    checked: areGridlinesVisible,
    showLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: axis,
    updateTicksVisibilityState: visible => {
      toggleTickLabelsVisibility(axis);
    },
    isAxisLabelVisible: areTickLabelsVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }), !useMultilayerTimeAxis && areTickLabelsVisible && /*#__PURE__*/_react.default.createElement(_shared_components.AxisLabelOrientationSelector, {
    axis: axis,
    selectedLabelOrientation: _shared_components.allowedOrientations.includes(orientation) ? orientation : 0 // Default to 0 if the value is not valid
    ,
    setLabelOrientation: newOrientation => {
      setOrientation(axis, newOrientation);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 9
    }
  }), setEndzoneVisibility && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showEnzones', {
      defaultMessage: 'Show partial data markers'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "lnsshowEndzones",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showEnzones', {
      defaultMessage: 'Show partial data markers'
    }),
    onChange: () => setEndzoneVisibility(!Boolean(endzonesVisible)),
    checked: Boolean(endzonesVisible),
    showLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  })), setCurrentTimeMarkerVisibility && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showCurrenTimeMarker', {
      defaultMessage: 'Show current time marker'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "lnsshowCurrentTimeMarker",
    label: _i18n.i18n.translate('xpack.lens.xyChart.showCurrenTimeMarker', {
      defaultMessage: 'Show current time marker'
    }),
    onChange: () => setCurrentTimeMarkerVisibility(!Boolean(currentTimeMarkerVisible)),
    checked: Boolean(currentTimeMarkerVisible),
    showLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 11
    }
  })), setScale && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.setScale', {
      defaultMessage: 'Axis scale'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    fullWidth: true,
    "data-test-subj": "lnsScaleSelect",
    "aria-label": _i18n.i18n.translate('xpack.lens.xyChart.setScale', {
      defaultMessage: 'Axis scale'
    }),
    options: [{
      text: _i18n.i18n.translate('xpack.lens.xyChart.scaleLinear', {
        defaultMessage: 'Linear'
      }),
      value: 'linear'
    }, {
      text: _i18n.i18n.translate('xpack.lens.xyChart.scaleLog', {
        defaultMessage: 'Logarithmic'
      }),
      value: 'log'
    }, {
      text: _i18n.i18n.translate('xpack.lens.xyChart.scaleSquare', {
        defaultMessage: 'Square root'
      }),
      value: 'sqrt'
    }],
    onChange: ({
      target
    }) => {
      if (!setScaleWithExtent || !extent) return;
      const newScale = target.value;
      setScaleWithExtent({
        ...extent,
        ...(0, _axis_extent_settings.getBounds)(extent.mode, newScale, dataBounds)
      }, newScale);
    },
    value: scale,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 11
    }
  })), localExtent && setLocalExtent && /*#__PURE__*/_react.default.createElement(_shared_components.AxisBoundsControl, {
    type: axis !== 'x' ? 'metric' : 'bucket',
    extent: localExtent,
    scaleType: scale,
    setExtent: setLocalExtent,
    dataBounds: dataBounds,
    hasBarOrArea: hasBarOrAreaOnAxis,
    disableCustomRange: hasPercentageAxis,
    testSubjPrefix: "lnsXY"
    // X axis is passing the extent object only in case of numeric histogram
    ,
    canHaveNiceValues: axis !== 'x' || Boolean(extent),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 9
    }
  }));
};
exports.XyAxisSettings = XyAxisSettings;