"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FontSizeInput = FontSizeInput;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/tagcloud/tagcloud_toolbar/font_size_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FontSizeInput(props) {
  const [fontSize, setFontSize] = (0, _react.useState)([props.minFontSize, props.maxFontSize]);
  const [, cancel] = (0, _useDebounce.default)(() => {
    props.onChange(fontSize[0], fontSize[1]);
  }, 150, [fontSize]);
  (0, _react.useEffect)(() => {
    return () => {
      cancel();
    };
  }, [cancel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, {
    id: "tagCloudFontSizeSlider",
    min: 1,
    max: 120,
    step: 1,
    value: fontSize,
    onChange: value => {
      setFontSize(value);
    },
    showLabels: true,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.lens.label.tagcloud.fontSizeLabel', {
      defaultMessage: 'Font size'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
}