"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionLegendValues = exports.legendOptions = exports.PartitionLegendSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _partition_charts_meta = require("../partition_charts_meta");
var _constants = require("../../../../common/constants");
var _datasource_default_values = require("../../../shared_components/datasource_default_values");
var _render_helpers = require("../render_helpers");
var _shared_components = require("../../../shared_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/partition/toolbar/legend_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PartitionLegendSettings = ({
  state,
  setState,
  frame
}) => {
  var _PartitionChartsMeta$, _PartitionChartsMeta$2, _layer$secondaryGroup, _layer$secondaryGroup2, _layer$truncateLegend2;
  const layer = state.layers[0];
  const legendSize = layer.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _chartExpressionsCommon.LegendSize.AUTO);
  const onStateChange = (0, _react.useCallback)(part => {
    setState({
      ...state,
      layers: [{
        ...layer,
        ...part
      }]
    });
  }, [layer, state, setState]);
  const onLegendDisplayChange = (0, _react.useCallback)(optionId => {
    onStateChange({
      legendDisplay: legendOptions.find(({
        id
      }) => id === optionId).value
    });
  }, [onStateChange]);
  const onLegendPositionChange = (0, _react.useCallback)(id => onStateChange({
    legendPosition: id
  }), [onStateChange]);
  const onNestedLegendChange = (0, _react.useCallback)(id => onStateChange({
    nestedLegend: !layer.nestedLegend
  }), [layer, onStateChange]);
  const onTruncateLegendChange = (0, _react.useCallback)(() => {
    var _layer$truncateLegend;
    const current = (_layer$truncateLegend = layer.truncateLegend) !== null && _layer$truncateLegend !== void 0 ? _layer$truncateLegend : true;
    onStateChange({
      truncateLegend: !current
    });
  }, [layer, onStateChange]);
  const onLegendMaxLinesChange = (0, _react.useCallback)(val => onStateChange({
    legendMaxLines: val
  }), [onStateChange]);
  const onLegendSizeChange = (0, _react.useCallback)(val => onStateChange({
    legendSize: val
  }), [onStateChange]);
  const onLegendStatsChange = (0, _react.useCallback)(legendStats => {
    onStateChange({
      legendStats
    });
  }, [onStateChange]);
  const defaultTruncationValue = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, frame.datasourceLayers).truncateText;
  return /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettings, {
    groupPosition: 'none',
    legendOptions: legendOptions,
    mode: layer.legendDisplay,
    onDisplayChange: onLegendDisplayChange,
    legendStats: (0, _render_helpers.getLegendStats)(layer, state.shape),
    allowedLegendStats: (_PartitionChartsMeta$ = _partition_charts_meta.PartitionChartsMeta[state.shape]) !== null && _PartitionChartsMeta$ !== void 0 && _PartitionChartsMeta$.legend.defaultLegendStats ? partitionLegendValues : undefined,
    onLegendStatsChange: onLegendStatsChange,
    position: layer.legendPosition,
    onPositionChange: onLegendPositionChange,
    renderNestedLegendSwitch: !((_PartitionChartsMeta$2 = _partition_charts_meta.PartitionChartsMeta[state.shape]) !== null && _PartitionChartsMeta$2 !== void 0 && _PartitionChartsMeta$2.legend.hideNestedLegendSwitch) && layer.primaryGroups.length + ((_layer$secondaryGroup = (_layer$secondaryGroup2 = layer.secondaryGroups) === null || _layer$secondaryGroup2 === void 0 ? void 0 : _layer$secondaryGroup2.length) !== null && _layer$secondaryGroup !== void 0 ? _layer$secondaryGroup : 0) > 1,
    nestedLegend: Boolean(layer.nestedLegend),
    onNestedLegendChange: onNestedLegendChange,
    shouldTruncate: (_layer$truncateLegend2 = layer.truncateLegend) !== null && _layer$truncateLegend2 !== void 0 ? _layer$truncateLegend2 : defaultTruncationValue,
    onTruncateLegendChange: onTruncateLegendChange,
    maxLines: layer === null || layer === void 0 ? void 0 : layer.legendMaxLines,
    onMaxLinesChange: onLegendMaxLinesChange,
    legendSize: legendSize,
    onLegendSizeChange: onLegendSizeChange,
    showAutoLegendSizeOption: hadAutoLegendSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  });
};
exports.PartitionLegendSettings = PartitionLegendSettings;
const partitionLegendValues = exports.partitionLegendValues = [{
  value: _charts.LegendValue.Value,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.value', {
    defaultMessage: 'Value'
  })
}];
const legendOptions = exports.legendOptions = [{
  id: 'pieLegendDisplay-default',
  value: _constants.LegendDisplay.DEFAULT,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.auto', {
    defaultMessage: 'Auto'
  })
}, {
  id: 'pieLegendDisplay-show',
  value: _constants.LegendDisplay.SHOW,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: 'pieLegendDisplay-hide',
  value: _constants.LegendDisplay.HIDE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];