"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PartitionAppearanceSettings = PartitionAppearanceSettings;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lensCommon = require("@kbn/lens-common");
var _partition_charts_meta = require("../partition_charts_meta");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/partition/toolbar/appearance_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptySizeRatioLabel = _i18n.i18n.translate('xpack.lens.pieChart.donutHole', {
  defaultMessage: 'Donut hole'
});
function PartitionAppearanceSettings(props) {
  const {
    state,
    setState
  } = props;
  const layer = state.layers[0];
  const {
    emptySizeRatioOptions
  } = _partition_charts_meta.PartitionChartsMeta[state.shape].toolbar;
  const onEmptySizeRatioChange = (0, _react.useCallback)(([option]) => {
    if (option.value === 'none') {
      setState({
        ...state,
        shape: 'pie',
        layers: [{
          ...layer,
          emptySizeRatio: undefined
        }]
      });
    } else {
      var _emptySizeRatioOption;
      const emptySizeRatio = emptySizeRatioOptions === null || emptySizeRatioOptions === void 0 ? void 0 : (_emptySizeRatioOption = emptySizeRatioOptions.find(({
        id
      }) => id === option.value)) === null || _emptySizeRatioOption === void 0 ? void 0 : _emptySizeRatioOption.value;
      setState({
        ...state,
        shape: 'donut',
        layers: [{
          ...layer,
          emptySizeRatio
        }]
      });
    }
  }, [emptySizeRatioOptions, layer, setState, state]);
  const options = emptySizeRatioOptions && emptySizeRatioOptions.map(({
    id,
    label,
    icon
  }) => ({
    value: id,
    label,
    prepend: icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 23
      }
    }) : undefined
  }));
  const selectedOption = emptySizeRatioOptions ? emptySizeRatioOptions.find(({
    value
  }) => {
    var _layer$emptySizeRatio;
    return value === (state.shape === 'pie' ? 0 : (_layer$emptySizeRatio = layer.emptySizeRatio) !== null && _layer$emptySizeRatio !== void 0 ? _layer$emptySizeRatio : _lensCommon.PARTITION_EMPTY_SIZE_RADIUS.SMALL);
  }) : undefined;
  const selectedOptions = selectedOption ? [{
    value: selectedOption.id,
    label: selectedOption.label
  }] : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: emptySizeRatioLabel,
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": "lnsEmptySizeRatioOption",
    "aria-label": _i18n.i18n.translate('xpack.lens.pieChart.donutHole', {
      defaultMessage: 'Donut hole'
    }),
    onChange: onEmptySizeRatioChange,
    isClearable: false,
    options: options,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    prepend: selectedOption !== null && selectedOption !== void 0 && selectedOption.icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: selectedOption.icon,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 41
      }
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
}