"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationTypes = exports.PartitionChartsMeta = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
var _charts = require("@elastic/charts");
var _lensCommon = require("@kbn/lens-common");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const categoryOptions = [{
  id: _constants.CategoryDisplay.HIDE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.categoriesHideLabel', {
    defaultMessage: 'Hide'
  })
}, {
  id: _constants.CategoryDisplay.INSIDE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.categoriesInsideOnlyLabel', {
    defaultMessage: 'Inside'
  })
}, {
  id: _constants.CategoryDisplay.DEFAULT,
  label: _i18n.i18n.translate('xpack.lens.pieChart.autoCategoriesLabel', {
    defaultMessage: 'Auto'
  })
}];
const categoryOptionsTreemap = [{
  id: _constants.CategoryDisplay.HIDE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.hideTreemapCategoriesLabel', {
    defaultMessage: 'Hide'
  })
}, {
  id: _constants.CategoryDisplay.DEFAULT,
  label: _i18n.i18n.translate('xpack.lens.pieChart.showTreemapCategoriesLabel', {
    defaultMessage: 'Show'
  })
}];
const numberOptions = [{
  id: _constants.NumberDisplay.HIDDEN,
  label: _i18n.i18n.translate('xpack.lens.pieChart.hiddenNumbersLabel', {
    defaultMessage: 'Hide'
  })
}, {
  id: _constants.NumberDisplay.VALUE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.integerLabel', {
    defaultMessage: 'Integer'
  })
}, {
  id: _constants.NumberDisplay.PERCENT,
  label: _i18n.i18n.translate('xpack.lens.pieChart.percentageLabel', {
    defaultMessage: 'Percentage'
  })
}];
const emptySizeRatioOptions = [{
  id: 'emptySizeRatioOption-none',
  value: 0,
  label: _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioOptions.none', {
    defaultMessage: 'None'
  })
}, {
  id: 'emptySizeRatioOption-small',
  icon: _chartIcons.IconDonutHoleSmall,
  value: _lensCommon.PARTITION_EMPTY_SIZE_RADIUS.SMALL,
  label: _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioOptions.small', {
    defaultMessage: 'Small'
  })
}, {
  id: 'emptySizeRatioOption-medium',
  value: _lensCommon.PARTITION_EMPTY_SIZE_RADIUS.MEDIUM,
  icon: _chartIcons.IconDonutHoleMedium,
  label: _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioOptions.medium', {
    defaultMessage: 'Medium'
  })
}, {
  id: 'emptySizeRatioOption-large',
  value: _lensCommon.PARTITION_EMPTY_SIZE_RADIUS.LARGE,
  icon: _chartIcons.IconDonutHoleLarge,
  label: _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioOptions.large', {
    defaultMessage: 'Large'
  })
}];
const sharedPieDonutOptions = {
  icon: _chartIcons.IconChartPie,
  label: _i18n.i18n.translate('xpack.lens.pie.pielabel', {
    defaultMessage: 'Pie'
  }),
  maxBuckets: 3,
  toolbar: {
    categoryOptions,
    numberOptions,
    emptySizeRatioOptions
  },
  legend: {
    getShowLegendDefault: bucketColumns => bucketColumns.length > 1
  },
  sortPriority: 6,
  description: _i18n.i18n.translate('xpack.lens.pie.visualizationDescription', {
    defaultMessage: 'Display parts of a whole in a circular format.'
  })
};
const PartitionChartsMeta = exports.PartitionChartsMeta = {
  pie: {
    id: 'pie',
    ...sharedPieDonutOptions
  },
  donut: {
    id: 'donut',
    ...sharedPieDonutOptions
  },
  waffle: {
    id: 'waffle',
    icon: _chartIcons.IconChartWaffle,
    label: _i18n.i18n.translate('xpack.lens.pie.wafflelabel', {
      defaultMessage: 'Waffle'
    }),
    maxBuckets: 1,
    toolbar: {
      isDisabled: true,
      categoryOptions: [],
      numberOptions: []
    },
    legend: {
      flat: true,
      defaultLegendStats: [_charts.LegendValue.Value],
      hideNestedLegendSwitch: true,
      getShowLegendDefault: () => true
    },
    sortPriority: 9,
    description: _i18n.i18n.translate('xpack.lens.waffle.visualizationDescription', {
      defaultMessage: 'Represent data proportions via a grid of colored cells.'
    })
  },
  treemap: {
    id: 'treemap',
    icon: _chartIcons.IconChartTreemap,
    label: _i18n.i18n.translate('xpack.lens.pie.treemaplabel', {
      defaultMessage: 'Treemap'
    }),
    maxBuckets: 2,
    toolbar: {
      categoryOptions: categoryOptionsTreemap,
      numberOptions
    },
    legend: {
      getShowLegendDefault: () => false
    },
    sortPriority: 11,
    description: _i18n.i18n.translate('xpack.lens.treemap.visualizationDescription', {
      defaultMessage: 'Use nested rectangles to show proportions and hierarchy.'
    })
  },
  mosaic: {
    id: 'mosaic',
    icon: _chartIcons.IconChartMosaic,
    label: _i18n.i18n.translate('xpack.lens.pie.mosaiclabel', {
      defaultMessage: 'Mosaic'
    }),
    maxBuckets: 2,
    toolbar: {
      categoryOptions: [],
      numberOptions
    },
    legend: {
      getShowLegendDefault: () => false
    },
    sortPriority: 13,
    description: _i18n.i18n.translate('xpack.lens.mosaic.visualizationDescription', {
      defaultMessage: 'Show proportions of categorical data with rectangles.'
    })
  }
};
const visualizationTypes = exports.visualizationTypes = [{
  ...PartitionChartsMeta.pie,
  subtypes: ['pie', 'donut']
}, PartitionChartsMeta.waffle, PartitionChartsMeta.treemap, PartitionChartsMeta.mosaic];