"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flyoutContainerStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flyoutOpenCloseAnimation = (0, _react.keyframes)`
  0% {
    opacity: 0;
    transform: translateX(100%);
  }
  75% {
    opacity: 1;
    transform: translateX(0%);
  }
`;
const flyoutContainerStyles = euiThemeContext => (0, _react.css)`
  border-left: ${euiThemeContext.euiTheme.border.thin};
  ${(0, _eui.euiShadow)(euiThemeContext, 'xl', {
  border: 'none'
})};
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  height: 100%;
  z-index: ${euiThemeContext.euiTheme.levels.flyout};
  background: ${euiThemeContext.euiTheme.colors.backgroundBasePlain};
  display: flex;
  flex-direction: column;
  align-items: stretch;
  animation: ${flyoutOpenCloseAnimation} ${euiThemeContext.euiTheme.animation.normal}
    ${euiThemeContext.euiTheme.animation.resistance};
  .lnsIndexPatternDimensionEditor--padded {
    padding: ${euiThemeContext.euiTheme.size.base};
  }
  .lnsIndexPatternDimensionEditor--collapseNext {
    margin-bottom: -${euiThemeContext.euiTheme.size.l};
    border-top: ${euiThemeContext.euiTheme.border.thin};
    margin-top: 0 !important;
  }
`;
exports.flyoutContainerStyles = flyoutContainerStyles;