"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiHasAbortController = apiHasAbortController;
exports.apiHasLastReloadRequestTime = apiHasLastReloadRequestTime;
exports.apiHasLensComponentCallbacks = apiHasLensComponentCallbacks;
exports.apiHasLensComponentProps = apiHasLensComponentProps;
exports.apiPublishesInlineEditingCapabilities = apiPublishesInlineEditingCapabilities;
exports.isLensApi = exports.isApiESQLVariablesCompatible = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function apiHasLensCallbacks(api) {
  const fns = ['getSavedVis', 'getViewUnderlyingDataArgs', 'isTextBasedLanguage', 'getTextBasedLanguage'];
  return fns.every(fn => typeof api[fn] === 'function');
}
const isLensApi = api => {
  return Boolean(api && (0, _presentationPublishing.apiIsOfType)(api, 'lens') && 'canViewUnderlyingData$' in api && apiHasLensCallbacks(api) && (0, _presentationPublishing.apiPublishesTitle)(api) && (0, _presentationPublishing.apiPublishesUnifiedSearch)(api));
};
exports.isLensApi = isLensApi;
function apiHasLensComponentCallbacks(api) {
  return (0, _lodash.isObject)(api) && ['onFilter', 'onBrushEnd', 'onLoad', 'onTableRowClick', 'onBeforeBadgesRender'].some(fn => Object.hasOwn(api, fn));
}
function apiHasLensComponentProps(api) {
  return (0, _lodash.isObject)(api) && ['style', 'className', 'noPadding', 'viewMode', 'abortController'].some(prop => Object.hasOwn(api, prop));
}
function apiHasAbortController(api) {
  return (0, _lodash.isObject)(api) && Object.hasOwn(api, 'abortController');
}
function apiHasLastReloadRequestTime(api) {
  return (0, _lodash.isObject)(api) && Object.hasOwn(api, 'lastReloadRequestTime');
}
function apiPublishesInlineEditingCapabilities(api) {
  return (0, _lodash.isObject)(api) && Object.hasOwn(api, 'canEditInline');
}
const isApiESQLVariablesCompatible = api => {
  return Boolean(api && (api === null || api === void 0 ? void 0 : api.esqlVariables$) !== undefined && (api === null || api === void 0 ? void 0 : api.controlGroupApi$) !== undefined && (api === null || api === void 0 ? void 0 : api.children$) !== undefined);
};
exports.isApiESQLVariablesCompatible = isApiESQLVariablesCompatible;