"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionPanel = SuggestionPanel;
exports.SuggestionPanelWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _interpreter = require("@kbn/interpreter");
var _i18n = require("@kbn/i18n");
var _ebtTools = require("@kbn/ebt-tools");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _utils = require("../../utils");
var _suggestion_helpers = require("./suggestion_helpers");
var _expression_helpers = require("./expression_helpers");
var _memoized_error_notification = require("../../lens_ui_errors/memoized_error_notification");
var _state_helpers = require("./state_helpers");
var _state_management = require("../../state_management");
var _get_application_user_messages = require("../../app_plugin/get_application_user_messages");
var _editor_frame_service_context = require("../editor_frame_service_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/suggestion_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_SUGGESTIONS_DISPLAYED = 5;
const LOCAL_STORAGE_SUGGESTIONS_PANEL = 'LENS_SUGGESTIONS_PANEL_HIDDEN';
const configurationsValid = (currentDataSource, currentDatasourceState, currentVisualization, currentVisualizationState, frame) => {
  try {
    var _currentDataSource$ge, _currentDataSource$ge2, _currentVisualization, _currentVisualization2;
    return (0, _get_application_user_messages.filterAndSortUserMessages)([...((_currentDataSource$ge = currentDataSource === null || currentDataSource === void 0 ? void 0 : (_currentDataSource$ge2 = currentDataSource.getUserMessages) === null || _currentDataSource$ge2 === void 0 ? void 0 : _currentDataSource$ge2.call(currentDataSource, currentDatasourceState, {
      frame,
      setState: () => {}
    })) !== null && _currentDataSource$ge !== void 0 ? _currentDataSource$ge : []), ...((_currentVisualization = currentVisualization === null || currentVisualization === void 0 ? void 0 : (_currentVisualization2 = currentVisualization.getUserMessages) === null || _currentVisualization2 === void 0 ? void 0 : _currentVisualization2.call(currentVisualization, currentVisualizationState, {
      frame
    })) !== null && _currentVisualization !== void 0 ? _currentVisualization : [])], undefined, {
      severity: 'error'
    }).length === 0;
  } catch (e) {
    return false;
  }
};
const PreviewRenderer = ({
  withLabel,
  ExpressionRendererComponent,
  expression,
  hasError,
  onRender
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const onErrorMessage = /*#__PURE__*/_react.default.createElement("div", {
    css: suggestionStyles.icon(euiThemeContext),
    "data-test-subj": "lnsSuggestionPanel__error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "xl",
    color: "danger",
    type: "warning",
    "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.previewErrorLabel', {
      defaultMessage: 'Preview rendering failed'
    }),
    content: _i18n.i18n.translate('xpack.lens.editorFrame.previewErrorLabel', {
      defaultMessage: 'Preview rendering failed'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        display: flex;
        height: 100%;
        width: 100%;
        pointer-events: none;
        ${withLabel ? `height: calc(100% - ${euiTheme.size.l});` : ''}
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }, !expression || hasError ? onErrorMessage : /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, {
    className: "lnsSuggestionPanel__expressionRenderer",
    padding: "s",
    renderMode: "preview",
    expression: expression,
    onRender$: onRender,
    debounce: 2000,
    renderError: () => {
      return onErrorMessage;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }));
};
const SuggestionPreview = ({
  preview,
  ExpressionRenderer: ExpressionRendererComponent,
  selected,
  onSelect,
  showTitleAsLabel,
  onRender,
  wrapSuggestions
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const xsFontSize = (0, _eui.useEuiFontSize)('xs');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: preview.title,
    anchorProps: wrapSuggestions ? {
      css: (0, _react2.css)`
                display: flex;
                flex-direction: column;
                flex-basis: calc(50% - 9px);
              `
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `lnsSuggestion-${(0, _lodash.camelCase)(preview.title)}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    css: (0, _react2.css)`
            position: relative; // Let the expression progress indicator position itself against the button
            flex: 0 0 auto;
            height: 100px;
            margin-right: ${euiTheme.size.s};
            margin-left: ${euiTheme.size.xxs};
            margin-bottom: ${euiTheme.size.xxs};
            padding: 0 ${euiTheme.size.s};
            box-shadow: none !important; // sass-lint:disable-line no-important

            &:focus {
              transform: none !important; // sass-lint:disable-line no-important
              ${(0, _eui.euiFocusRing)(euiThemeContext)};
            }
            ${selected ? `
              background-color: ${euiTheme.colors.lightestShade} !important; // sass-lint:disable-line no-important
              border-color: ${euiTheme.colors.mediumShade} !important; // sass-lint:disable-line no-important

              &:not(:focus) {
                box-shadow: none !important; // sass-lint:disable-line no-important
              }

              &:focus {
                ${(0, _eui.euiFocusRing)(euiThemeContext)};
              }

              &:hover {
                transform: none !important; // sass-lint:disable-line no-important
              }
              ` : ''}
            ${!wrapSuggestions ? `
                  width: 150px !important; // sass-lint:disable-line no-important
                ` : ''}
          `,
    paddingSize: "none",
    "data-test-subj": "lnsSuggestion",
    onClick: onSelect,
    "aria-current": !!selected,
    "aria-label": preview.title,
    element: "button",
    role: "listitem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, preview.expression || preview.error ? /*#__PURE__*/_react.default.createElement(PreviewRenderer, {
    ExpressionRendererComponent: ExpressionRendererComponent,
    expression: preview.expression && (0, _interpreter.toExpression)(preview.expression),
    withLabel: Boolean(showTitleAsLabel),
    hasError: Boolean(preview.error),
    onRender: onRender,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement("span", {
    css: suggestionStyles.icon(euiThemeContext),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: preview.icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 15
    }
  })), showTitleAsLabel && /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
                ${(0, _eui.euiTextTruncate)()}
                ${xsFontSize};
                font-weight: ${euiTheme.font.weight.bold};
                display: block;
                text-align: center;
                flex-grow: 0;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 13
    }
  }, preview.title))));
};
const SuggestionPanelWrapper = props => {
  const isFullscreenDatasource = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  return isFullscreenDatasource ? null : /*#__PURE__*/_react.default.createElement(SuggestionPanel, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 42
    }
  }));
};
exports.SuggestionPanelWrapper = SuggestionPanelWrapper;
function SuggestionPanel({
  frame,
  ExpressionRenderer: ExpressionRendererComponent,
  getUserMessages,
  nowProvider,
  core,
  showOnlyIcons,
  wrapSuggestions,
  toggleAccordionCb,
  isAccordionOpen
}) {
  const {
    datasourceMap,
    visualizationMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const activeData = (0, _state_management.useLensSelector)(_state_management.selectStagedActiveData);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const existsStagedPreview = (0, _state_management.useLensSelector)(state => Boolean(state.lens.stagedPreview));
  const currentVisualization = (0, _state_management.useLensSelector)(_state_management.selectCurrentVisualization);
  const currentDatasourceStates = (0, _state_management.useLensSelector)(_state_management.selectCurrentDatasourceStates);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const framePublicAPI = (0, _state_management.useLensSelector)(state => (0, _state_management.selectFramePublicAPI)(state, datasourceMap));
  const changesApplied = (0, _state_management.useLensSelector)(_state_management.selectChangesApplied);
  // get user's selection from localStorage, this key defines if the suggestions panel will be hidden or not
  const initialAccordionStatusValue = isAccordionOpen != null ? !Boolean(isAccordionOpen) : false;
  const [hideSuggestions, setHideSuggestions] = (0, _useLocalStorage.default)(LOCAL_STORAGE_SUGGESTIONS_PANEL, initialAccordionStatusValue);
  (0, _react.useEffect)(() => {
    if (isAccordionOpen != null) {
      setHideSuggestions(!Boolean(isAccordionOpen));
    }
  }, [isAccordionOpen, setHideSuggestions]);
  const toggleSuggestions = (0, _react.useCallback)(() => {
    setHideSuggestions(!hideSuggestions);
    toggleAccordionCb === null || toggleAccordionCb === void 0 ? void 0 : toggleAccordionCb(!hideSuggestions);
  }, [setHideSuggestions, hideSuggestions, toggleAccordionCb]);
  const missingIndexPatterns = (0, _state_helpers.getMissingIndexPattern)(activeDatasourceId ? datasourceMap[activeDatasourceId] : null, activeDatasourceId ? datasourceStates[activeDatasourceId] : null, frame.dataViews.indexPatterns);
  const {
    suggestions,
    currentStateExpression,
    currentStateError
  } = (0, _react.useMemo)(() => {
    const newSuggestions = missingIndexPatterns.length ? [] : (0, _suggestion_helpers.getSuggestions)({
      datasourceMap,
      datasourceStates: currentDatasourceStates,
      visualizationMap,
      activeVisualization: currentVisualization.activeId ? visualizationMap[currentVisualization.activeId] : undefined,
      visualizationState: currentVisualization.state,
      activeData,
      dataViews: frame.dataViews
    }).filter(({
      hide,
      visualizationId,
      visualizationState: suggestionVisualizationState,
      datasourceState: suggestionDatasourceState,
      datasourceId: suggestionDatasourceId
    }) => {
      return !hide && configurationsValid(suggestionDatasourceId ? datasourceMap[suggestionDatasourceId] : null, suggestionDatasourceState, visualizationMap[visualizationId], suggestionVisualizationState, framePublicAPI);
    }).slice(0, MAX_SUGGESTIONS_DISPLAYED).map(suggestion => ({
      ...suggestion,
      previewExpression: preparePreviewExpression(suggestion, visualizationMap[suggestion.visualizationId], datasourceMap, currentDatasourceStates, frame, nowProvider)
    }));
    const hasErrors = getUserMessages ? getUserMessages(['visualization', 'visualizationInEditor'], {
      severity: 'error'
    }).length > 0 : false;
    const newStateExpression = currentVisualization.state && currentVisualization.activeId && !hasErrors ? preparePreviewExpression({
      visualizationState: currentVisualization.state
    }, visualizationMap[currentVisualization.activeId], datasourceMap, currentDatasourceStates, frame, nowProvider) : undefined;
    return {
      suggestions: newSuggestions,
      currentStateExpression: newStateExpression,
      currentStateError: hasErrors
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentDatasourceStates, currentVisualization.state, currentVisualization.activeId, activeDatasourceId, datasourceMap, visualizationMap, activeData]);
  const context = (0, _state_management.useLensSelector)(_state_management.selectExecutionContextSearch);
  const searchSessionId = (0, _state_management.useLensSelector)(_state_management.selectSearchSessionId);
  const contextRef = (0, _react.useRef)(context);
  contextRef.current = context;
  const sessionIdRef = (0, _react.useRef)(searchSessionId);
  sessionIdRef.current = searchSessionId;
  const AutoRefreshExpressionRenderer = (0, _react.useMemo)(() => {
    return props => /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, (0, _extends2.default)({}, props, {
      searchContext: contextRef.current,
      searchSessionId: sessionIdRef.current,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 445,
        columnNumber: 7
      }
    }));
  }, [ExpressionRendererComponent]);
  const [lastSelectedSuggestion, setLastSelectedSuggestion] = (0, _react.useState)(-1);
  (0, _react.useEffect)(() => {
    // if the staged preview is overwritten by a suggestion,
    // reset the selected index to "current visualization" because
    // we are not in transient suggestion state anymore
    if (!existsStagedPreview && lastSelectedSuggestion !== -1) {
      setLastSelectedSuggestion(-1);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [existsStagedPreview]);
  const startTime = (0, _react.useRef)(0);
  const initialRenderComplete = (0, _react.useRef)(false);
  const suggestionsRendered = (0, _react.useRef)([]);
  const totalSuggestions = suggestions.length + 1;
  const onSuggestionRender = (0, _react.useCallback)(suggestionIndex => {
    suggestionsRendered.current[suggestionIndex] = true;
    if (initialRenderComplete.current === false && suggestionsRendered.current.every(Boolean)) {
      initialRenderComplete.current = true;
      (0, _ebtTools.reportPerformanceMetricEvent)(core.analytics, {
        eventName: 'lensSuggestionsRenderTime',
        duration: performance.now() - startTime.current
      });
    }
  }, [core.analytics]);
  const rollbackToCurrentVisualization = (0, _react.useCallback)(() => {
    if (lastSelectedSuggestion !== -1) {
      setLastSelectedSuggestion(-1);
      dispatchLens((0, _state_management.rollbackSuggestion)());
      dispatchLens((0, _state_management.applyChanges)());
    }
  }, [dispatchLens, lastSelectedSuggestion]);
  if (!activeDatasourceId) {
    return null;
  }
  if (suggestions.length === 0) {
    return null;
  }
  const renderApplyChangesPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    className: "lnsSuggestionPanel__applyChangesPrompt",
    paddingSize: "m",
    css: (0, _react2.css)`
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        height: 100px;
        background-color: ${euiTheme.colors.lightestShade} !important;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 501,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    className: "lnsSuggestionPanel__applyChangesMessage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 514,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 515,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.suggestions.applyChangesPrompt",
    defaultMessage: "Latest changes must be applied to view suggestions.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "checkInCircleFilled",
    size: "s",
    className: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    onClick: () => dispatchLens((0, _state_management.applyChanges)()),
    "data-test-subj": "lnsApplyChanges__suggestions",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 523,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.suggestions.applyChangesLabel",
    defaultMessage: "Apply changes",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 530,
      columnNumber: 9
    }
  })));
  const renderSuggestionsUI = () => {
    suggestionsRendered.current = new Array(totalSuggestions).fill(false);
    startTime.current = performance.now();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentVisualization.activeId && !hideSuggestions && /*#__PURE__*/_react.default.createElement(SuggestionPreview, {
      preview: {
        error: currentStateError,
        expression: !showOnlyIcons ? currentStateExpression : undefined,
        icon: visualizationMap[currentVisualization.activeId].getDescription(currentVisualization.state).icon || 'empty',
        title: _i18n.i18n.translate('xpack.lens.suggestions.currentVisLabel', {
          defaultMessage: 'Current visualization'
        })
      },
      ExpressionRenderer: AutoRefreshExpressionRenderer,
      onSelect: rollbackToCurrentVisualization,
      selected: lastSelectedSuggestion === -1,
      showTitleAsLabel: true,
      onRender: () => onSuggestionRender(0),
      wrapSuggestions: wrapSuggestions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 544,
        columnNumber: 11
      }
    }), !hideSuggestions && suggestions.map((suggestion, index) => {
      return /*#__PURE__*/_react.default.createElement(SuggestionPreview, {
        preview: {
          expression: !showOnlyIcons ? suggestion.previewExpression : undefined,
          icon: suggestion.previewIcon,
          title: suggestion.title
        },
        ExpressionRenderer: AutoRefreshExpressionRenderer,
        key: index,
        onSelect: () => {
          if (lastSelectedSuggestion === index) {
            rollbackToCurrentVisualization();
          } else {
            setLastSelectedSuggestion(index);
            (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, suggestion, {
              applyImmediately: true
            });
          }
        },
        selected: index === lastSelectedSuggestion,
        onRender: () => onSuggestionRender(index + 1),
        showTitleAsLabel: showOnlyIcons,
        wrapSuggestions: wrapSuggestions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 567,
          columnNumber: 15
        }
      });
    }));
  };
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react2.css)`
        padding: 2px;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 600,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.editorFrame.suggestionPanelTitle",
    defaultMessage: "Suggestions",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 601,
      columnNumber: 9
    }
  })));
  const dangerAlpha10 = (0, _chromaJs.default)(euiTheme.colors.danger).alpha(0.1).css();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "lensSuggestionsPanel",
    buttonProps: {
      'data-test-subj': 'lensSuggestionsPanelToggleButton',
      paddingSize: wrapSuggestions ? 'm' : 's'
    },
    css: (0, _react2.css)`
        padding-bottom: ${wrapSuggestions ? 0 : euiTheme.size.s};
        .euiAccordion__buttonContent {
          width: 100%;
        }
      `,
    buttonContent: title,
    forceState: hideSuggestions ? 'closed' : 'open',
    onToggle: toggleSuggestions,
    extraAction: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideSuggestions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, existsStagedPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.lens.suggestion.refreshSuggestionTooltip', {
        defaultMessage: 'Refresh the suggestions based on the selected visualization.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 630,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "lensSubmitSuggestion",
      size: "xs",
      iconType: "refresh",
      onClick: () => {
        dispatchLens((0, _state_management.submitSuggestion)());
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 635,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.lens.sugegstion.refreshSuggestionLabel', {
      defaultMessage: 'Refresh'
    })))), wrapSuggestions && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 652,
        columnNumber: 13
      }
    }, suggestions.length + 1)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 610,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-scrollBar",
    "data-test-subj": "lnsSuggestionsPanel",
    role: "list",
    tabIndex: 0,
    css: (0, _react2.css)`
          flex-wrap: ${wrapSuggestions ? 'wrap' : 'nowrap'};
          gap: ${wrapSuggestions ? euiTheme.size.base : 0};
          overflow-x: scroll;
          overflow-y: hidden;
          display: flex;
          padding-top: ${euiTheme.size.xs};
          mask-image: linear-gradient(
            to right,
            ${dangerAlpha10} 0%,
            ${euiTheme.colors.danger} 5px,
            ${euiTheme.colors.danger} calc(100% - 5px),
            ${dangerAlpha10} 100%
          );
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 659,
      columnNumber: 7
    }
  }, changesApplied ? renderSuggestionsUI() : renderApplyChangesPrompt()));
}
function getPreviewExpression(visualizableState, visualization, datasources, datasourceStates, frame, nowProvider) {
  if (!visualization.toPreviewExpression) {
    return null;
  }
  const suggestionFrameApi = {
    datasourceLayers: {
      ...frame.datasourceLayers
    }
  };
  try {
    // use current frame api and patch apis for changed datasource layers
    if (visualizableState.keptLayerIds && visualizableState.datasourceId && visualizableState.datasourceState) {
      const datasource = datasources[visualizableState.datasourceId];
      const datasourceState = visualizableState.datasourceState;
      const updatedLayerApis = (0, _lodash.pick)(frame.datasourceLayers, visualizableState.keptLayerIds);
      const changedLayers = datasource.getLayers(visualizableState.datasourceState);
      changedLayers.forEach(layerId => {
        if (updatedLayerApis[layerId]) {
          updatedLayerApis[layerId] = datasource.getPublicAPI({
            layerId,
            state: datasourceState,
            indexPatterns: frame.dataViews.indexPatterns
          });
        }
        suggestionFrameApi.datasourceLayers[layerId] = updatedLayerApis[layerId];
      });
    }
    const datasourceExpressionsByLayers = (0, _expression_helpers.getDatasourceExpressionsByLayers)(datasources, datasourceStates, frame.dataViews.indexPatterns, frame.dateRange, nowProvider.get());
    return visualization.toPreviewExpression(visualizableState.visualizationState, suggestionFrameApi.datasourceLayers, datasourceExpressionsByLayers);
  } catch (error) {
    (0, _memoized_error_notification.showMemoizedErrorNotification)(error);
    return null;
  }
}
function preparePreviewExpression(visualizableState, visualization, datasourceMap, datasourceStates, framePublicAPI, nowProvider) {
  const suggestionDatasourceId = visualizableState.datasourceId;
  const suggestionDatasourceState = visualizableState.datasourceState;
  const datasourceStatesWithSuggestions = suggestionDatasourceId ? {
    ...datasourceStates,
    [suggestionDatasourceId]: {
      isLoading: false,
      state: suggestionDatasourceState
    }
  } : datasourceStates;
  const expression = getPreviewExpression(visualizableState, visualization, datasourceMap, datasourceStatesWithSuggestions, framePublicAPI, nowProvider);
  if (!expression) {
    return;
  }
  return typeof expression === 'string' ? (0, _interpreter.fromExpression)(expression) : expression;
}
const suggestionStyles = {
  icon: ({
    euiTheme
  }) => (0, _react2.css)`
    color: ${euiTheme.colors.darkShade};
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: ${euiTheme.size.s};
    &:not(:only-child) {
      height: calc(100% - ${euiTheme.size.l});
    }
  `
};