"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerPanel = LayerPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _esQuery = require("@kbn/es-query");
var _unifiedTabs = require("@kbn/unified-tabs");
var _types_guards = require("../../../types_guards");
var _layer_header = require("./layer_header");
var _dimension_container = require("./dimension_container");
var _empty_dimension_button = require("./buttons/empty_dimension_button");
var _draggable_dimension_button = require("./buttons/draggable_dimension_button");
var _use_focus_update = require("./use_focus_update");
var _state_management = require("../../../state_management");
var _flyout_container = require("../../../shared_components/flyout_container");
var _layer_tabs = require("../../../app_plugin/shared/edit_on_the_fly/layer_tabs");
var _fake_dimension_button = require("./buttons/fake_dimension_button");
var _user_messages_utils = require("../../../user_messages_utils");
var _type_guards = require("../../../react_embeddable/type_guards");
var _esql_editor = require("./esql_editor");
var _editor_frame_service_context = require("../../editor_frame_service_context");
var _open_layer_settings = require("./layer_actions/open_layer_settings");
var _remove_layer_action = require("./layer_actions/remove_layer_action");
var _clone_layer_action = require("./layer_actions/clone_layer_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/layer_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LayerPanel(props) {
  var _framePublicAPI$datas, _datasourceStates$dat, _layerDatasource$uniq, _editorProps$attribut, _openColumnGroup$dime;
  const {
    datasourceMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const [openDimension, setOpenDimension] = (0, _react.useState)({});
  const [isPanelSettingsOpen, setPanelSettingsOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    framePublicAPI,
    layerId,
    isOnlyLayer,
    dimensionGroups,
    onRemoveLayer,
    onCloneLayer,
    layerIndex,
    activeVisualization,
    updateVisualization,
    updateDatasource,
    toggleFullscreen,
    updateAll,
    updateDatasourceAsync,
    visualizationState,
    onChangeIndexPattern,
    core,
    onDropToDimension,
    setIsInlineFlyoutVisible,
    onlyAllowSwitchToSubtypes,
    ...editorProps
  } = props;
  const {
    parentApi
  } = editorProps;
  const esqlVariables = (0, _presentationPublishing.useStateFromPublishingSubject)((0, _type_guards.isApiESQLVariablesCompatible)(parentApi) ? parentApi === null || parentApi === void 0 ? void 0 : parentApi.esqlVariables$ : new _rxjs.BehaviorSubject(undefined));
  const isInlineEditing = Boolean(props === null || props === void 0 ? void 0 : props.setIsInlineFlyoutVisible);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const isFullscreen = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  const dateRange = (0, _state_management.useLensSelector)(_state_management.selectResolvedDateRange);
  (0, _react.useEffect)(() => {
    // is undefined when the dimension panel is closed
    setIsInlineFlyoutVisible === null || setIsInlineFlyoutVisible === void 0 ? void 0 : setIsInlineFlyoutVisible(!openDimension.openColumnId);
  }, [openDimension.openColumnId, setIsInlineFlyoutVisible]);
  const panelRef = (0, _react.useRef)(null);
  const settingsPanelRef = (0, _react.useRef)(null);
  const closeDimensionEditor = () => {
    if (layerDatasource) {
      if (layerDatasource.updateStateOnCloseDimension) {
        const newState = layerDatasource.updateStateOnCloseDimension({
          state: layerDatasourceState,
          layerId,
          columnId: openColumnId
        });
        if (newState) {
          props.updateDatasource(datasourceId, newState);
        }
      }
    }
    setOpenDimension({});
    if (isFullscreen) {
      toggleFullscreen();
    }
  };
  const layerVisualizationConfigProps = {
    layerId,
    state: props.visualizationState,
    frame: props.framePublicAPI,
    dateRange,
    activeData: props.framePublicAPI.activeData
  };
  const datasourcePublicAPI = (_framePublicAPI$datas = framePublicAPI.datasourceLayers) === null || _framePublicAPI$datas === void 0 ? void 0 : _framePublicAPI$datas[layerId];
  const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
  let layerDatasourceState = datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$dat = datasourceStates[datasourceId]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state;
  // try again with aliases
  if (!layerDatasourceState && datasourcePublicAPI !== null && datasourcePublicAPI !== void 0 && datasourcePublicAPI.datasourceAliasIds && datasourceStates) {
    const aliasId = datasourcePublicAPI.datasourceAliasIds.find(id => {
      var _datasourceStates$id;
      return datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$id = datasourceStates[id]) === null || _datasourceStates$id === void 0 ? void 0 : _datasourceStates$id.state;
    });
    if (aliasId) {
      layerDatasourceState = datasourceStates[aliasId].state;
    }
  }
  const layerDatasource = datasourceId ? datasourceMap[datasourceId] : undefined;
  const layerDatasourceConfigProps = {
    state: layerDatasourceState,
    setState: newState => {
      updateDatasource(datasourceId, newState);
    },
    layerId,
    frame: props.framePublicAPI,
    dateRange
  };
  const columnLabelMap = !layerDatasource && activeVisualization.getUniqueLabels ? activeVisualization.getUniqueLabels(props.visualizationState) : layerDatasource === null || layerDatasource === void 0 ? void 0 : (_layerDatasource$uniq = layerDatasource.uniqueLabels) === null || _layerDatasource$uniq === void 0 ? void 0 : _layerDatasource$uniq.call(layerDatasource, layerDatasourceConfigProps === null || layerDatasourceConfigProps === void 0 ? void 0 : layerDatasourceConfigProps.state, framePublicAPI.dataViews.indexPatterns);
  const isEmptyLayer = !dimensionGroups.some(d => d.accessors.length > 0);
  const {
    openColumnId,
    openColumnGroup,
    isComplete
  } = openDimension;
  (0, _react.useEffect)(() => {
    if (!openColumnId) {
      return;
    }
    const derivedOpenColumnGroup = dimensionGroups.find(group => group.accessors.some(a => a.columnId === openColumnId));
    // dont update if nothing has changed
    if (isComplete === !!derivedOpenColumnGroup && (derivedOpenColumnGroup === null || derivedOpenColumnGroup === void 0 ? void 0 : derivedOpenColumnGroup.groupId) === (openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.groupId)) {
      return;
    }
    if (derivedOpenColumnGroup) {
      // if column is found, mark it as complete. If it's moved to another group, update the group
      setOpenDimension({
        openColumnId,
        openColumnGroup: derivedOpenColumnGroup,
        isComplete: !!derivedOpenColumnGroup
      });
    }
    // if column is not found but is not new (is complete), close the dimension panel
    if (isComplete && !derivedOpenColumnGroup) {
      setOpenDimension({});
    }
  }, [openColumnId, dimensionGroups, isComplete, openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.groupId]);
  const allAccessors = dimensionGroups.flatMap(group => group.accessors.map(accessor => accessor.columnId));
  const {
    setNextFocusedId: setNextFocusedButtonId,
    removeRef: removeButtonRef,
    registerNewRef: registerNewButtonRef
  } = (0, _use_focus_update.useFocusUpdate)(allAccessors);
  const onDrop = (0, _react.useCallback)((source, target, dropType) => {
    if (!dropType) {
      return;
    }
    if (!(0, _types_guards.isOperation)(target)) {
      throw new Error('Drop target should be an operation');
    }
    if (dropType === 'reorder' || dropType === 'field_replace' || dropType === 'field_add') {
      setNextFocusedButtonId(source.id);
    } else {
      setNextFocusedButtonId(target.columnId);
    }
    onDropToDimension({
      source,
      target,
      dropType
    });
  }, [setNextFocusedButtonId, onDropToDimension]);
  const isDimensionPanelOpen = Boolean(openColumnId);
  const updateDataLayerState = (0, _react.useCallback)((newState, {
    isDimensionComplete = true,
    // this flag is a hack to force a sync render where it was planned an async/setTimeout state update
    // TODO: revisit this once we get rid of updateDatasourceAsync upstream
    forceRender = false
  } = {}) => {
    if (!openColumnGroup || !openColumnId) {
      return;
    }
    if (allAccessors.includes(openColumnId)) {
      if (isDimensionComplete) {
        if (forceRender) {
          updateDatasource(datasourceId, newState);
        } else {
          updateDatasourceAsync(datasourceId, newState);
        }
      } else {
        // The datasource can indicate that the previously-valid column is no longer
        // complete, which clears the visualization. This keeps the flyout open and reuses
        // the previous columnId
        props.updateDatasource(datasourceId, newState);
        props.onRemoveDimension({
          layerId,
          columnId: openColumnId
        });
      }
    } else if (isDimensionComplete) {
      updateAll(datasourceId, newState, activeVisualization.setDimension({
        layerId,
        groupId: openColumnGroup.groupId,
        columnId: openColumnId,
        prevState: visualizationState,
        frame: framePublicAPI
      }));
    } else {
      if (forceRender) {
        updateDatasource(datasourceId, newState);
      } else {
        updateDatasourceAsync(datasourceId, newState);
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [openDimension, openColumnGroup, openColumnId, activeVisualization, datasourceId, layerId, updateAll, updateDatasourceAsync, visualizationState, framePublicAPI]);
  const {
    dataViews
  } = props.framePublicAPI;
  const [datasource] = Object.values(framePublicAPI.datasourceLayers);
  const isTextBasedLanguage = (datasource === null || datasource === void 0 ? void 0 : datasource.isTextBasedLanguage()) || (0, _esQuery.isOfAggregateQueryType)((_editorProps$attribut = editorProps.attributes) === null || _editorProps$attribut === void 0 ? void 0 : _editorProps$attribut.state.query) || false;
  const visualizationLayerSettings = (0, _react.useMemo)(() => {
    var _activeVisualization$;
    return ((_activeVisualization$ = activeVisualization.hasLayerSettings) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization, {
      layerId,
      state: visualizationState,
      frame: props.framePublicAPI
    })) || {
      data: false,
      appearance: false
    };
  }, [activeVisualization, layerId, props.framePublicAPI, visualizationState]);
  const hasLayerSettings = Boolean(Object.values(visualizationLayerSettings).some(Boolean) && activeVisualization.LayerSettingsComponent || (layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.LayerSettingsComponent));
  const layerSettingsAction = (0, _react.useMemo)(() => (0, _open_layer_settings.getOpenLayerSettingsAction)({
    openLayerSettings: () => setPanelSettingsOpen(true),
    hasLayerSettings
  }), [hasLayerSettings]);
  const layerActions = (0, _react.useMemo)(() => {
    var _activeVisualization$2;
    // Only show clear layer button for single layer visualizations
    // or if it's the only layer in a multi-layer visualization.
    if (!isOnlyLayer) {
      return null;
    }
    const layerType = activeVisualization.getLayerType(layerId, visualizationState);
    const removeLayerAction = (0, _remove_layer_action.getRemoveLayerAction)({
      execute: () => onRemoveLayer(layerId),
      layerIndex,
      layerType,
      isOnlyLayer: true,
      core,
      customModalText: (_activeVisualization$2 = activeVisualization.getCustomRemoveLayerText) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, layerId, visualizationState)
    });
    const cloneLayerAction = (0, _clone_layer_action.getCloneLayerAction)({
      execute: onCloneLayer,
      layerIndex,
      activeVisualization,
      isTextBasedLanguage
    });
    return {
      removeLayerAction,
      cloneLayerAction
    };
  }, [activeVisualization, isOnlyLayer, layerId, visualizationState, layerIndex, core, onRemoveLayer, onCloneLayer, isTextBasedLanguage]);
  const supportsMultipleLayers = (0, _react.useMemo)(() => Boolean(activeVisualization.getAddLayerButtonComponent), [activeVisualization]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("section", {
    tabIndex: -1,
    css: (0, _react2.css)`
          margin-bottom: ${euiTheme.size.base};
          // disable focus ring for mouse clicks, leave it for keyboard users
          &:focus:not(:focus-visible) {
            animation: none !important; // sass-lint:disable-line no-important
          }
        `,
    "data-test-subj": `lns-layerPanel-${layerIndex}`,
    id: _layer_tabs.LENS_LAYER_TABS_CONTENT_ID,
    role: "tabpanel",
    "aria-labelledby": (0, _unifiedTabs.getTabIdAttribute)({
      id: layerId,
      label: 'tab item'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("header", {
    className: "lnsLayerPanel__layerHeader",
    css: (0, _react2.css)`
              padding: 0 0 ${euiTheme.size.base} 0;
              border-bottom: ${euiTheme.border.thin};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
                  min-width: 0; // fixes truncation for too long chart switcher labels
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_layer_header.LayerHeader, {
    layerConfigProps: {
      ...layerVisualizationConfigProps,
      setState: props.updateVisualization,
      onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
        indexPatternId,
        layerId,
        visualizationId: activeVisualization.id
      })
    },
    activeVisualizationId: activeVisualization.id,
    onlyAllowSwitchToSubtypes: onlyAllowSwitchToSubtypes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 17
    }
  })), props.displayLayerSettings && layerSettingsAction.isCompatible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: layerSettingsAction.displayName,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: layerSettingsAction.icon,
    "aria-label": layerSettingsAction.displayName,
    onClick: () => layerSettingsAction.execute(null),
    "data-test-subj": layerSettingsAction['data-test-subj'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 21
    }
  }))), layerActions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: layerActions.removeLayerAction.displayName,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: layerActions.removeLayerAction.icon,
    color: layerActions.removeLayerAction.color,
    "aria-label": layerActions.removeLayerAction.displayName,
    onClick: () => layerActions.removeLayerAction.execute(null),
    "data-test-subj": layerActions.removeLayerAction['data-test-subj'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 23
    }
  }))), supportsMultipleLayers && !isTextBasedLanguage ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: layerActions.cloneLayerAction.displayName,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: layerActions.cloneLayerAction.icon,
    color: layerActions.cloneLayerAction.color,
    "aria-label": layerActions.cloneLayerAction.displayName,
    onClick: () => layerActions.cloneLayerAction.execute(null),
    "data-test-subj": layerActions.cloneLayerAction['data-test-subj'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 25
    }
  }))) : null)), props.indexPatternService && !isTextBasedLanguage && (layerDatasource || activeVisualization.LayerPanelComponent) && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 17
    }
  }), layerDatasource && props.indexPatternService && !isTextBasedLanguage && /*#__PURE__*/_react.default.createElement(layerDatasource.LayerPanelComponent, {
    layerId,
    state: layerDatasourceState,
    activeData: props.framePublicAPI.activeData,
    dataViews,
    onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
      indexPatternId,
      layerId,
      datasourceId
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 473,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_esql_editor.ESQLEditor, (0, _extends2.default)({
    uiSettings: core.uiSettings,
    http: core.http,
    isTextBasedLanguage: isTextBasedLanguage,
    framePublicAPI: framePublicAPI,
    layerId: layerId
  }, editorProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 484,
      columnNumber: 13
    }
  })), activeVisualization.LayerPanelComponent && /*#__PURE__*/_react.default.createElement(activeVisualization.LayerPanelComponent, {
    layerId,
    state: visualizationState,
    frame: framePublicAPI,
    setState: props.updateVisualization,
    onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
      indexPatternId,
      layerId,
      visualizationId: activeVisualization.id
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 493,
      columnNumber: 15
    }
  })), dimensionGroups.filter(group => !group.isHidden).map((group, groupIndex) => {
    var _activeVisualization$5;
    let errorText = '';
    if (!isEmptyLayer || isInlineEditing) {
      if (group.requiredMinDimensionCount && group.requiredMinDimensionCount > group.accessors.length) {
        if (group.requiredMinDimensionCount > 1) {
          errorText = _i18n.i18n.translate('xpack.lens.editorFrame.requiresTwoOrMoreFieldsWarningLabel', {
            defaultMessage: 'Requires {requiredMinDimensionCount} fields',
            values: {
              requiredMinDimensionCount: group.requiredMinDimensionCount
            }
          });
        } else {
          errorText = _i18n.i18n.translate('xpack.lens.editorFrame.requiresFieldWarningLabel', {
            defaultMessage: 'Requires field'
          });
        }
      } else if (group.dimensionsTooMany && group.dimensionsTooMany > 0) {
        errorText = _i18n.i18n.translate('xpack.lens.editorFrame.tooManyDimensionsSingularWarningLabel', {
          defaultMessage: 'Please remove {dimensionsTooMany, plural, one {a dimension} other {{dimensionsTooMany} dimensions}}',
          values: {
            dimensionsTooMany: group.dimensionsTooMany
          }
        });
      }
    }
    const isOptional = !group.requiredMinDimensionCount && !group.suggestedValue;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      css: (0, _react2.css)`
                    padding: ${euiTheme.size.base} 0;
                    &:last-child {
                      border-radius: 0 0 ${euiTheme.border.radius.medium}
                        ${euiTheme.border.radius.medium};
                    }

                    // Add border to the top of the next same panel
                    & + & {
                      border-top: ${euiTheme.border.thin};
                      margin-top: 0;
                    }

                    & > * {
                      margin-bottom: 0;
                    }

                    // Targeting EUI class as we are unable to apply a class to this element in component
                    &,
                    .euiFormRow__fieldWrapper {
                      & > * + * {
                        margin-top: ${euiTheme.size.s};
                      }
                    }
                  `,
      className: "lnsLayerPanel__row",
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, group.groupLabel, group.groupTooltip && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: group.groupTooltip,
        iconProps: {
          className: 'eui-alignTop'
        },
        position: "top",
        size: "s",
        type: "question",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 583,
          columnNumber: 27
        }
      }))),
      labelAppend: isOptional ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        "data-test-subj": "lnsGroup_optional",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 599,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.lens.editorFrame.optionalDimensionLabel', {
        defaultMessage: 'Optional'
      })) : null,
      labelType: "legend",
      key: group.groupId,
      isInvalid: Boolean(errorText),
      error: errorText,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 550,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, group.accessors.length ? /*#__PURE__*/_react.default.createElement(_domDragDrop.ReorderProvider, {
      dataTestSubj: "lnsDragDrop",
      css: (0, _react2.css)`
                          margin: -${euiTheme.size.xs} 0;
                          padding: ${euiTheme.size.xs} 0;
                        `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 613,
        columnNumber: 23
      }
    }, group.accessors.map((accessorConfig, accessorIndex) => {
      var _props$getUserMessage, _props$getUserMessage2, _activeVisualization$3, _columnLabelMap$colum, _columnLabelMap$acces, _activeVisualization$4, _columnLabelMap$colum2;
      const {
        columnId
      } = accessorConfig;
      const messages = (_props$getUserMessage = props === null || props === void 0 ? void 0 : (_props$getUserMessage2 = props.getUserMessages) === null || _props$getUserMessage2 === void 0 ? void 0 : _props$getUserMessage2.call(props, 'dimensionButton', {
        dimensionId: columnId
      })) !== null && _props$getUserMessage !== void 0 ? _props$getUserMessage : [];
      const firstMessage = messages.at(0);
      return /*#__PURE__*/_react.default.createElement(_draggable_dimension_button.DraggableDimensionButton, {
        activeVisualization: activeVisualization,
        registerNewButtonRef: registerNewButtonRef,
        order: [2, layerIndex, groupIndex, accessorIndex],
        target: {
          id: columnId,
          layerId,
          columnId,
          groupId: group.groupId,
          filterOperations: group.filterOperations,
          prioritizedOperation: group.prioritizedOperation,
          isMetricDimension: group === null || group === void 0 ? void 0 : group.isMetricDimension,
          indexPatternId: layerDatasource ? layerDatasource.getUsedDataView(layerDatasourceState, layerId) : (_activeVisualization$3 = activeVisualization.getUsedDataView) === null || _activeVisualization$3 === void 0 ? void 0 : _activeVisualization$3.call(activeVisualization, visualizationState, layerId),
          humanData: {
            label: (_columnLabelMap$colum = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[columnId]) !== null && _columnLabelMap$colum !== void 0 ? _columnLabelMap$colum : '',
            groupLabel: group.groupLabel,
            position: accessorIndex + 1,
            layerNumber: layerIndex + 1
          }
        },
        group: group,
        key: columnId,
        state: layerDatasourceState,
        layerDatasource: layerDatasource,
        datasourceLayers: framePublicAPI.datasourceLayers,
        onDrop: onDrop,
        indexPatterns: dataViews.indexPatterns,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 630,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DimensionButton, {
        accessorConfig: accessorConfig,
        label: (_columnLabelMap$acces = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[accessorConfig.columnId]) !== null && _columnLabelMap$acces !== void 0 ? _columnLabelMap$acces : '',
        groupLabel: group.groupLabel,
        onClick: id => {
          setOpenDimension({
            openColumnGroup: group,
            openColumnId: id
          });
        },
        onRemoveClick: id => {
          props.onRemoveDimension({
            columnId: id,
            layerId
          });
          removeButtonRef(id);
        },
        message: firstMessage ? {
          severity: firstMessage.severity,
          content: firstMessage.shortMessage || (0, _user_messages_utils.getLongMessage)(firstMessage)
        } : undefined,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 663,
          columnNumber: 31
        }
      }, layerDatasource ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, layerDatasource.DimensionTriggerComponent({
        ...layerDatasourceConfigProps,
        columnId: accessorConfig.columnId,
        groupId: group.groupId,
        filterOperations: group.filterOperations,
        indexPatterns: dataViews.indexPatterns
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeVisualization === null || activeVisualization === void 0 ? void 0 : (_activeVisualization$4 = activeVisualization.DimensionTriggerComponent) === null || _activeVisualization$4 === void 0 ? void 0 : _activeVisualization$4.call(activeVisualization, {
        columnId,
        label: (_columnLabelMap$colum2 = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[columnId]) !== null && _columnLabelMap$colum2 !== void 0 ? _columnLabelMap$colum2 : ''
      }))));
    })) : null, group.fakeFinalAccessor && /*#__PURE__*/_react.default.createElement(_fake_dimension_button.FakeDimensionButton, {
      label: group.fakeFinalAccessor.label,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 713,
        columnNumber: 23
      }
    }), group.supportsMoreColumns ? /*#__PURE__*/_react.default.createElement(_empty_dimension_button.EmptyDimensionButton, {
      activeVisualization: activeVisualization,
      order: [2, layerIndex, groupIndex, group.accessors.length],
      group: group,
      target: {
        layerId,
        groupId: group.groupId,
        filterOperations: group.filterOperations,
        prioritizedOperation: group.prioritizedOperation,
        isNewColumn: true,
        isMetricDimension: group === null || group === void 0 ? void 0 : group.isMetricDimension,
        indexPatternId: layerDatasource ? layerDatasource.getUsedDataView(layerDatasourceState, layerId) : (_activeVisualization$5 = activeVisualization.getUsedDataView) === null || _activeVisualization$5 === void 0 ? void 0 : _activeVisualization$5.call(activeVisualization, visualizationState, layerId),
        humanData: {
          groupLabel: group.groupLabel,
          layerNumber: layerIndex + 1,
          position: group.accessors.length + 1,
          label: _i18n.i18n.translate('xpack.lens.indexPattern.emptyDimensionButton', {
            defaultMessage: 'Empty dimension'
          })
        }
      },
      layerDatasource: layerDatasource,
      state: layerDatasourceState,
      datasourceLayers: framePublicAPI.datasourceLayers,
      onClick: id => {
        props.onEmptyDimensionAdd(id, group);
        setOpenDimension({
          openColumnGroup: group,
          openColumnId: id
        });
      },
      onDrop: onDrop,
      indexPatterns: dataViews.indexPatterns,
      isInlineEditing: isInlineEditing,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 717,
        columnNumber: 23
      }
    }) : null));
  }))), ((layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.LayerSettingsComponent) || (activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.LayerSettingsComponent)) && /*#__PURE__*/_react.default.createElement(_flyout_container.FlyoutContainer, {
    panelRef: el => settingsPanelRef.current = el,
    isFullscreen: false,
    label: _i18n.i18n.translate('xpack.lens.editorFrame.layerSettingsTitle', {
      defaultMessage: 'Layer settings'
    }),
    isOpen: isPanelSettingsOpen,
    handleClose: () => {
      setPanelSettingsOpen(false);
    },
    isInlineEditing: isInlineEditing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 762,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: layerId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 774,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 775,
      columnNumber: 13
    }
  }, layerDatasource !== null && layerDatasource !== void 0 && layerDatasource.LayerSettingsComponent || visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    margin-bottom: ${euiTheme.size.base};
                  `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 777,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 783,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.lens.editorFrame.layerSettings.headingData', {
    defaultMessage: 'Data'
  }))) : null, (layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.LayerSettingsComponent) && /*#__PURE__*/_react.default.createElement(layerDatasource.LayerSettingsComponent, (0, _extends2.default)({}, layerDatasourceConfigProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 791,
      columnNumber: 17
    }
  })), activeVisualization !== null && activeVisualization !== void 0 && activeVisualization.LayerSettingsComponent && visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(activeVisualization.LayerSettingsComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
    setState: props.updateVisualization,
    panelRef: settingsPanelRef,
    section: 'data',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 794,
      columnNumber: 17
    }
  })) : null, visualizationLayerSettings.appearance ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    margin-bottom: ${euiTheme.size.base};
                  `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 804,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 810,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.lens.editorFrame.layerSettings.headingAppearance', {
    defaultMessage: 'Appearance'
  }))) : null, (activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.LayerSettingsComponent) && /*#__PURE__*/_react.default.createElement(activeVisualization.LayerSettingsComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
    setState: props.updateVisualization,
    panelRef: settingsPanelRef,
    section: 'appearance',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 818,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_dimension_container.DimensionContainer, {
    panelRef: el => panelRef.current = el,
    isOpen: isDimensionPanelOpen,
    isFullscreen: isFullscreen,
    label: (_openColumnGroup$dime = openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.dimensionEditorGroupLabel) !== null && _openColumnGroup$dime !== void 0 ? _openColumnGroup$dime : (openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.groupLabel) || '',
    isInlineEditing: isInlineEditing,
    handleClose: closeDimensionEditor,
    panel: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 839,
        columnNumber: 11
      }
    }, openColumnGroup && openColumnId && layerDatasource && layerDatasource.DimensionEditorComponent({
      ...layerDatasourceConfigProps,
      core: props.core,
      columnId: openColumnId,
      groupId: openColumnGroup.groupId,
      hideGrouping: openColumnGroup.hideGrouping,
      filterOperations: openColumnGroup.filterOperations,
      isMetricDimension: openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.isMetricDimension,
      dimensionGroups,
      toggleFullscreen,
      isFullscreen,
      setState: updateDataLayerState,
      supportStaticValue: Boolean(openColumnGroup.supportStaticValue),
      paramEditorCustomProps: openColumnGroup.paramEditorCustomProps,
      enableFormatSelector: openColumnGroup.enableFormatSelector !== false,
      layerType: activeVisualization.getLayerType(layerId, visualizationState),
      indexPatterns: dataViews.indexPatterns,
      activeData: layerVisualizationConfigProps.activeData,
      esqlVariables,
      dataSectionExtra: !isFullscreen && openDimension.isComplete && activeVisualization.DimensionEditorDataExtraComponent && /*#__PURE__*/_react.default.createElement(activeVisualization.DimensionEditorDataExtraComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
        groupId: openColumnGroup.groupId,
        accessor: openColumnId,
        datasource,
        setState: props.updateVisualization,
        addLayer: props.addLayer,
        removeLayer: props.onRemoveLayer,
        panelRef,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 865,
          columnNumber: 21
        }
      }))
    }), openColumnGroup && openColumnId && !isFullscreen && openDimension.isComplete && activeVisualization.DimensionEditorComponent && (openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.enableDimensionEditor) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
                      padding: ${euiTheme.size.base} 0;
                    `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 886,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(activeVisualization.DimensionEditorComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
      groupId: openColumnGroup.groupId,
      accessor: openColumnId,
      datasource,
      setState: props.updateVisualization,
      addLayer: props.addLayer,
      removeLayer: props.onRemoveLayer,
      panelRef,
      isInlineEditing,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 891,
        columnNumber: 21
      }
    }))), activeVisualization.DimensionEditorAdditionalSectionComponent && /*#__PURE__*/_react.default.createElement(activeVisualization.DimensionEditorAdditionalSectionComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
      groupId: openColumnGroup.groupId,
      accessor: openColumnId,
      datasource,
      setState: props.updateVisualization,
      addLayer: props.addLayer,
      removeLayer: props.onRemoveLayer,
      panelRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 906,
        columnNumber: 21
      }
    })))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 831,
      columnNumber: 7
    }
  }));
}