"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigPanel = ConfigPanel;
exports.ConfigPanelWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _useShallowCompareEffect = _interopRequireDefault(require("react-use/lib/useShallowCompareEffect"));
var _react2 = require("@emotion/react");
var _lens_slice = require("../../../state_management/lens_slice");
var _layer_panel = require("./layer_panel");
var _id_generator = require("../../../id_generator");
var _state_management = require("../../../state_management");
var _editor_frame_service_context = require("../../editor_frame_service_context");
var _layer_tabs = require("../../../app_plugin/shared/edit_on_the_fly/layer_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/config_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfigPanelWrapper = exports.ConfigPanelWrapper = /*#__PURE__*/(0, _react.memo)(function ConfigPanelWrapper(props) {
  const {
    visualizationMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const activeVisualization = visualization.activeId ? visualizationMap[visualization.activeId] : null;
  return activeVisualization && visualization.state ? /*#__PURE__*/_react.default.createElement(ConfigPanel, (0, _extends2.default)({}, props, {
    activeVisualization: activeVisualization,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  })) : null;
});
function ConfigPanel(props) {
  const {
    datasourceMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const {
    activeVisualization,
    indexPatternService
  } = props;
  const {
    activeDatasourceId,
    visualization,
    datasourceStates
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const selectedLayerId = (0, _state_management.useLensSelector)(_state_management.selectSelectedLayerId);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const layerIds = (0, _react.useMemo)(() => activeVisualization.getLayerIds(visualization.state), [activeVisualization, visualization.state]);
  const focusLayerTabsContent = () => {
    setTimeout(() => {
      const element = document.getElementById(_layer_tabs.LENS_LAYER_TABS_CONTENT_ID);
      element === null || element === void 0 ? void 0 : element.focus({
        preventScroll: true
      });
    }, 0);
  };

  // need to use this instead of plain useEffect to compare actual values of layerIds
  // not just comparing the array references.
  (0, _useShallowCompareEffect.default)(() => {
    if (selectedLayerId) {
      focusLayerTabsContent();
    }
    // Needs layerIds to refocus when layers are removed
  }, [selectedLayerId, layerIds]);
  const setVisualizationState = (0, _react.useMemo)(() => newState => {
    dispatchLens((0, _state_management.updateVisualizationState)({
      visualizationId: activeVisualization.id,
      newState
    }));
  }, [activeVisualization.id, dispatchLens]);
  const updateDatasource = (0, _react.useMemo)(() => (datasourceId, newState, dontSyncLinkedDimensions) => {
    if (datasourceId) {
      dispatchLens((0, _state_management.updateDatasourceState)({
        newDatasourceState: typeof newState === 'function' ? newState(datasourceStates[datasourceId].state) : newState,
        datasourceId,
        clearStagedPreview: false,
        dontSyncLinkedDimensions
      }));
    }
  }, [dispatchLens, datasourceStates]);
  const updateDatasourceAsync = (0, _react.useMemo)(() => (datasourceId, newState) => {
    // React will synchronously update if this is triggered from a third party component,
    // which we don't want. The timeout lets user interaction have priority, then React updates.
    setTimeout(() => {
      updateDatasource(datasourceId, newState);
    });
  }, [updateDatasource]);
  const updateAll = (0, _react.useMemo)(() => (datasourceId, newDatasourceState, newVisualizationState) => {
    if (!datasourceId) return;
    // React will synchronously update if this is triggered from a third party component,
    // which we don't want. The timeout lets user interaction have priority, then React updates.

    setTimeout(() => {
      const newDsState = typeof newDatasourceState === 'function' ? newDatasourceState(datasourceStates[datasourceId].state) : newDatasourceState;
      const newVisState = typeof newVisualizationState === 'function' ? newVisualizationState(visualization.state) : newVisualizationState;
      dispatchLens((0, _state_management.updateVisualizationState)({
        visualizationId: activeVisualization.id,
        newState: newVisState,
        dontSyncLinkedDimensions: true // TODO: to refactor: this is quite brittle, we avoid to sync linked dimensions because we do it with datasourceState update
      }));
      dispatchLens((0, _state_management.updateDatasourceState)({
        newDatasourceState: newDsState,
        datasourceId,
        clearStagedPreview: false
      }));
    }, 0);
  }, [dispatchLens, visualization.state, datasourceStates, activeVisualization.id]);
  const toggleFullscreen = (0, _react.useCallback)(() => {
    dispatchLens((0, _state_management.setToggleFullscreen)());
  }, [dispatchLens]);
  const handleDimensionDrop = (0, _react.useCallback)(payload => {
    dispatchLens((0, _lens_slice.onDropToDimension)(payload));
  }, [dispatchLens]);
  const onRemoveLayer = (0, _react.useCallback)(async layerToRemoveId => {
    var _props$framePublicAPI;
    const datasourcePublicAPI = (_props$framePublicAPI = props.framePublicAPI.datasourceLayers) === null || _props$framePublicAPI === void 0 ? void 0 : _props$framePublicAPI[layerToRemoveId];
    const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
    if (datasourceId) {
      var _datasourceStates$dat;
      const layerDatasource = datasourceMap[datasourceId];
      const layerDatasourceState = datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$dat = datasourceStates[datasourceId]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state;
      const trigger = props.uiActions.getTrigger(_public.UPDATE_FILTER_REFERENCES_TRIGGER);
      const action = await props.uiActions.getAction(_public.UPDATE_FILTER_REFERENCES_ACTION);
      action === null || action === void 0 ? void 0 : action.execute({
        trigger,
        fromDataView: layerDatasource.getUsedDataView(layerDatasourceState, layerToRemoveId),
        usedDataViews: layerDatasource.getLayers(layerDatasourceState).map(layer => layerDatasource.getUsedDataView(layerDatasourceState, layer)),
        defaultDataView: layerDatasource.getUsedDataView(layerDatasourceState)
      });
    }
    dispatchLens((0, _state_management.removeOrClearLayer)({
      visualizationId: activeVisualization.id,
      layerId: layerToRemoveId,
      layerIds
    }));
    focusLayerTabsContent();
  }, [activeVisualization.id, datasourceMap, datasourceStates, dispatchLens, layerIds, props.framePublicAPI.datasourceLayers, props.uiActions]);
  const onChangeIndexPattern = (0, _react.useCallback)(async ({
    indexPatternId,
    datasourceId,
    visualizationId,
    layerId
  }) => {
    var _props$indexPatternSe;
    const indexPatterns = await ((_props$indexPatternSe = props.indexPatternService) === null || _props$indexPatternSe === void 0 ? void 0 : _props$indexPatternSe.ensureIndexPattern({
      id: indexPatternId,
      cache: props.framePublicAPI.dataViews.indexPatterns
    }));
    if (indexPatterns) {
      dispatchLens((0, _lens_slice.changeIndexPattern)({
        indexPatternId,
        datasourceIds: datasourceId ? [datasourceId] : [],
        visualizationIds: visualizationId ? [visualizationId] : [],
        layerId,
        dataViews: {
          indexPatterns
        }
      }));
    }
  }, [dispatchLens, props.framePublicAPI.dataViews.indexPatterns, props.indexPatternService]);

  // This will be used only in dimension editors like metric charts which adds a hidden layer.
  // That's why we don't update the currently selected or focused layer.
  const addLayer = (0, _react.useCallback)((layerType, extraArg, ignoreInitialValues, seriesType) => {
    const layerId = (0, _id_generator.generateId)();
    dispatchLens((0, _state_management.addLayer)({
      layerId,
      layerType,
      extraArg,
      ignoreInitialValues,
      seriesType
    }));
  }, [dispatchLens]);
  const registerLibraryAnnotationGroupFunction = (0, _react.useCallback)(groupInfo => dispatchLens((0, _state_management.registerLibraryAnnotationGroup)(groupInfo)), [dispatchLens]);
  const isOnlyLayer = (0, _react.useMemo)(() => {
    if (layerIds.length === 1) {
      return true;
    }
    const visibleLayerIds = layerIds.filter(id => {
      const config = activeVisualization.getConfiguration({
        layerId: id,
        frame: props.framePublicAPI,
        state: visualization.state
      });
      return !config.hidden;
    });
    return visibleLayerIds.length === 1;
  }, [activeVisualization, props.framePublicAPI, visualization.state, layerIds]);
  const layerConfig = (0, _react.useMemo)(() => {
    if (!selectedLayerId) return;
    return {
      layerId: selectedLayerId,
      layerType: activeVisualization.getLayerType(selectedLayerId, visualization.state),
      config: activeVisualization.getConfiguration({
        layerId: selectedLayerId,
        frame: props.framePublicAPI,
        state: visualization.state
      })
    };
  }, [activeVisualization, props.framePublicAPI, selectedLayerId, visualization.state]);
  const euiOverflowScroll = (0, _eui.useEuiOverflowScroll)('y');
  if (layerConfig !== null && layerConfig !== void 0 && layerConfig.config.hidden || !selectedLayerId || !layerConfig) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    css: (0, _react2.css)`
        .lnsApp & {
          padding: ${euiTheme.size.base} ${euiTheme.size.base} ${euiTheme.size.xl}
            calc(400px + ${euiTheme.size.base});
          margin-left: -400px;
          ${euiOverflowScroll}
          ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])} {
            padding-left: ${euiTheme.size.base};
            margin-left: 0;
          }
        }
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_layer_panel.LayerPanel, (0, _extends2.default)({}, props, {
    onDropToDimension: handleDimensionDrop,
    registerLibraryAnnotationGroup: registerLibraryAnnotationGroupFunction,
    dimensionGroups: layerConfig.config.groups,
    activeVisualization: activeVisualization,
    layerId: selectedLayerId,
    layerIndex: layerIds.indexOf(selectedLayerId),
    visualizationState: visualization.state,
    updateVisualization: setVisualizationState,
    updateDatasource: updateDatasource,
    updateDatasourceAsync: updateDatasourceAsync,
    displayLayerSettings: !props.hideLayerHeader,
    onChangeIndexPattern: args => {
      var _activeVisualization$, _activeVisualization$2;
      onChangeIndexPattern(args);
      const layersToRemove = (_activeVisualization$ = (_activeVisualization$2 = activeVisualization.getLayersToRemoveOnIndexPatternChange) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, visualization.state)) !== null && _activeVisualization$ !== void 0 ? _activeVisualization$ : [];
      layersToRemove.forEach(id => onRemoveLayer(id));
    },
    updateAll: updateAll,
    addLayer: addLayer,
    isOnlyLayer: isOnlyLayer,
    onEmptyDimensionAdd: (columnId, {
      groupId
    }) => {
      var _datasourceMap$active;
      // avoid state update if the datasource does not support initializeDimension
      if (activeDatasourceId != null && (_datasourceMap$active = datasourceMap[activeDatasourceId]) !== null && _datasourceMap$active !== void 0 && _datasourceMap$active.initializeDimension) {
        dispatchLens((0, _state_management.setLayerDefaultDimension)({
          layerId: selectedLayerId,
          columnId,
          groupId
        }));
      }
    },
    onCloneLayer: () => {
      dispatchLens((0, _state_management.cloneLayer)({
        layerId: selectedLayerId
      }));
    },
    onRemoveLayer: onRemoveLayer,
    onRemoveDimension: dimensionProps => {
      var _props$framePublicAPI2;
      const datasourcePublicAPI = (_props$framePublicAPI2 = props.framePublicAPI.datasourceLayers) === null || _props$framePublicAPI2 === void 0 ? void 0 : _props$framePublicAPI2[selectedLayerId];
      const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
      dispatchLens((0, _lens_slice.removeDimension)({
        ...dimensionProps,
        datasourceId
      }));
    },
    toggleFullscreen: toggleFullscreen,
    indexPatternService: indexPatternService,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 7
    }
  })));
}