"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddLayerButton = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _service = require("../../../data_views_service/service");
var _editor_frame_service_context = require("../../../editor_frame_service/editor_frame_service_context");
var _state_management = require("../../../state_management");
var _lens_slice = require("../../../state_management/lens_slice");
var _id_generator = require("../../../id_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddLayerButton = (framePublicAPI, coreStart, dataViews, uiActions, setIsInlineFlyoutVisible) => {
  const {
    visualizationMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const {
    visualization,
    datasourceStates,
    query
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeVisualization = visualization.activeId ? visualizationMap[visualization.activeId] : null;
  const indexPatternService = (0, _react.useMemo)(() => (0, _service.createIndexPatternService)({
    dataViews,
    uiActions,
    core: coreStart,
    updateIndexPatterns: (newIndexPatternsState, options) => {
      dispatchLens((0, _state_management.updateIndexPatterns)(newIndexPatternsState));
    },
    replaceIndexPattern: (newIndexPattern, oldId, options) => {
      dispatchLens((0, _lens_slice.replaceIndexpattern)({
        newIndexPattern,
        oldId
      }));
    }
  }), [coreStart, dispatchLens, dataViews, uiActions]);
  const addLayer = (0, _react.useCallback)((layerType, extraArg, ignoreInitialValues, seriesType) => {
    const layerId = (0, _id_generator.generateId)();
    dispatchLens((0, _state_management.addLayer)({
      layerId,
      layerType,
      extraArg,
      ignoreInitialValues,
      seriesType
    }));
    dispatchLens((0, _state_management.setSelectedLayerId)({
      layerId
    }));
  }, [dispatchLens]);
  const registerLibraryAnnotationGroupFunction = (0, _react.useCallback)(groupInfo => dispatchLens((0, _state_management.registerLibraryAnnotationGroup)(groupInfo)), [dispatchLens]);
  const hideAddLayerButton = query && (0, _esQuery.isOfAggregateQueryType)(query);
  return (0, _react.useMemo)(() => {
    var _activeVisualization$, _activeVisualization$2;
    if (hideAddLayerButton) {
      return null;
    }
    return (_activeVisualization$ = activeVisualization === null || activeVisualization === void 0 ? void 0 : (_activeVisualization$2 = activeVisualization.getAddLayerButtonComponent) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, {
      state: visualization.state,
      supportedLayers: activeVisualization.getSupportedLayers(visualization.state, framePublicAPI),
      addLayer,
      ensureIndexPattern: async specOrId => {
        let indexPatternId;
        if (typeof specOrId === 'string') {
          indexPatternId = specOrId;
        } else {
          const dataView = await dataViews.create(specOrId);
          if (!dataView.id) {
            return;
          }
          indexPatternId = dataView.id;
        }
        const newIndexPatterns = await (indexPatternService === null || indexPatternService === void 0 ? void 0 : indexPatternService.ensureIndexPattern({
          id: indexPatternId,
          cache: framePublicAPI.dataViews.indexPatterns
        }));
        if (newIndexPatterns) {
          dispatchLens((0, _state_management.changeIndexPattern)({
            dataViews: {
              indexPatterns: newIndexPatterns
            },
            datasourceIds: Object.keys(datasourceStates),
            visualizationIds: visualization.activeId ? [visualization.activeId] : [],
            indexPatternId
          }));
        }
      },
      registerLibraryAnnotationGroup: registerLibraryAnnotationGroupFunction,
      isInlineEditing: Boolean(setIsInlineFlyoutVisible)
    })) !== null && _activeVisualization$ !== void 0 ? _activeVisualization$ : null;
  }, [activeVisualization, addLayer, datasourceStates, dispatchLens, hideAddLayerButton, indexPatternService, dataViews, framePublicAPI, setIsInlineFlyoutVisible, registerLibraryAnnotationGroupFunction, visualization.activeId, visualization.state]);
};
exports.useAddLayerButton = useAddLayerButton;