"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchLensFeatureFlags = fetchLensFeatureFlags;
exports.getLensFeatureFlagDefaults = getLensFeatureFlagDefaults;
exports.lensFeatureFlags = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensFeatureFlags = exports.lensFeatureFlags = {
  /**
   * Enables transforming lens state to/from new API Format over the wire.
   */
  apiFormat: {
    id: 'lens.apiFormat',
    type: 'boolean',
    fallback: false
  }
};
async function fetchLensFeatureFlags(service) {
  const fetchFeatureFlag = fetchFeatureFlagFn(service);
  const flags = await Promise.all(Object.entries(lensFeatureFlags).map(async ([key, flag]) => {
    const value = await fetchFeatureFlag(flag);
    return [key, value];
  }));
  return Object.fromEntries(flags);
}
function fetchFeatureFlagFn(service) {
  return function fetchFeatureFlag(flag) {
    switch (flag.type) {
      case 'boolean':
        return service.getBooleanValue(flag.id, flag.fallback);
      case 'number':
        return service.getNumberValue(flag.id, flag.fallback);
      case 'string':
        return service.getStringValue(flag.id, flag.fallback);
      default:
        throw new Error('unsupported flag type');
    }
  };
}
function getLensFeatureFlagDefaults() {
  return Object.entries(lensFeatureFlags).reduce((acc, [k, flag]) => {
    const key = k;
    acc[key] = flag.fallback;
    return acc;
  }, {});
}