"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromCounterRateLensStateToAPI = exports.fromCounterRateAPItoLensState = void 0;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromCounterRateAPItoLensState = (options, ref) => {
  const {
    format
  } = options;
  const {
    reducedTimeRange,
    ...sharedProps
  } = (0, _utils.getLensStateMetricSharedProps)(options);
  return {
    operationType: 'counter_rate',
    references: ref && ref.id ? [ref.id] : [],
    ...sharedProps,
    params: {
      ...(format ? {
        format: (0, _format.fromFormatAPIToLensState)(format)
      } : {})
    }
  };
};
exports.fromCounterRateAPItoLensState = fromCounterRateAPItoLensState;
const fromCounterRateLensStateToAPI = (options, ref) => {
  var _options$params;
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    reduced_time_range,
    ...sharedProps
  } = (0, _utils.getLensAPIMetricSharedProps)(options);
  return {
    operation: 'counter_rate',
    field: ref.field,
    ...sharedProps,
    ...((_options$params = options.params) !== null && _options$params !== void 0 && _options$params.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
};
exports.fromCounterRateLensStateToAPI = fromCounterRateLensStateToAPI;