"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildVisualizationAPI = buildVisualizationAPI;
exports.buildVisualizationState = buildVisualizationState;
var _lodash = require("lodash");
var _legend = require("./legend");
var _state_layers = require("./state_layers");
var _helpers = require("./helpers");
var _utils = require("../../utils");
var _api_layers = require("./api_layers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function convertFittingToStateFormat(fitting) {
  return {
    ...(fitting !== null && fitting !== void 0 && fitting.type ? {
      fittingFunction: (0, _lodash.capitalize)(fitting.type)
    } : {}),
    ...(fitting !== null && fitting !== void 0 && fitting.dotted ? {
      emphasizeFitting: fitting.dotted
    } : {}),
    ...(fitting !== null && fitting !== void 0 && fitting.end_value ? {
      endValue: (0, _lodash.capitalize)(fitting.end_value)
    } : {})
  };
}
function convertAPIExtentToStateFormat(extent) {
  switch (extent === null || extent === void 0 ? void 0 : extent.type) {
    case 'full':
      return {
        mode: 'full',
        ...(extent.integer_rounding != null ? {
          niceValues: extent.integer_rounding
        } : {})
      };
    case 'custom':
      return {
        mode: 'custom',
        lowerBound: extent.start,
        upperBound: extent.end,
        ...(extent.integer_rounding != null ? {
          niceValues: extent.integer_rounding
        } : {})
      };
    case 'focus':
      return {
        mode: 'dataBounds'
      };
    default:
      return;
  }
}
const orientationDictionary = {
  horizontal: 0,
  vertical: -90,
  angled: -45
};
function convertAxisSettingsToStateFormat(axis) {
  var _axis$x, _axis$left, _axis$right, _axis$x2, _axis$x2$title, _axis$left2, _axis$left2$title, _axis$right2, _axis$right2$title, _axis$x$title$visible, _axis$x3, _axis$x3$title, _axis$left$title$visi, _axis$left3, _axis$left3$title, _axis$right$title$vis, _axis$right3, _axis$right3$title, _axis$x4, _axis$left4, _axis$right4, _axis$x$ticks, _axis$x5, _axis$left$ticks, _axis$left5, _axis$right$ticks, _axis$right5, _axis$x6, _axis$left6, _axis$right6, _axis$x$grid, _axis$x7, _axis$left$grid, _axis$left7, _axis$right$grid, _axis$right7, _axis$x8, _axis$left8, _axis$right8, _axis$x$label_orienta, _axis$x9, _axis$left$label_orie, _axis$left9, _axis$right$label_ori, _axis$right9, _axis$x10, _axis$x10$title, _axis$left10, _axis$left10$title, _axis$right10, _axis$right10$title, _axis$left11, _axis$right11;
  const xExtent = convertAPIExtentToStateFormat(axis === null || axis === void 0 ? void 0 : (_axis$x = axis.x) === null || _axis$x === void 0 ? void 0 : _axis$x.extent);
  const yLeftExtent = convertAPIExtentToStateFormat(axis === null || axis === void 0 ? void 0 : (_axis$left = axis.left) === null || _axis$left === void 0 ? void 0 : _axis$left.extent);
  const yRightExtent = convertAPIExtentToStateFormat(axis === null || axis === void 0 ? void 0 : (_axis$right = axis.right) === null || _axis$right === void 0 ? void 0 : _axis$right.extent);
  const axisTitlesVisibilitySettings = (axis === null || axis === void 0 ? void 0 : (_axis$x2 = axis.x) === null || _axis$x2 === void 0 ? void 0 : (_axis$x2$title = _axis$x2.title) === null || _axis$x2$title === void 0 ? void 0 : _axis$x2$title.visible) == null && (axis === null || axis === void 0 ? void 0 : (_axis$left2 = axis.left) === null || _axis$left2 === void 0 ? void 0 : (_axis$left2$title = _axis$left2.title) === null || _axis$left2$title === void 0 ? void 0 : _axis$left2$title.visible) == null && (axis === null || axis === void 0 ? void 0 : (_axis$right2 = axis.right) === null || _axis$right2 === void 0 ? void 0 : (_axis$right2$title = _axis$right2.title) === null || _axis$right2$title === void 0 ? void 0 : _axis$right2$title.visible) == null ? undefined : {
    x: (_axis$x$title$visible = axis === null || axis === void 0 ? void 0 : (_axis$x3 = axis.x) === null || _axis$x3 === void 0 ? void 0 : (_axis$x3$title = _axis$x3.title) === null || _axis$x3$title === void 0 ? void 0 : _axis$x3$title.visible) !== null && _axis$x$title$visible !== void 0 ? _axis$x$title$visible : true,
    yLeft: (_axis$left$title$visi = axis === null || axis === void 0 ? void 0 : (_axis$left3 = axis.left) === null || _axis$left3 === void 0 ? void 0 : (_axis$left3$title = _axis$left3.title) === null || _axis$left3$title === void 0 ? void 0 : _axis$left3$title.visible) !== null && _axis$left$title$visi !== void 0 ? _axis$left$title$visi : true,
    yRight: (_axis$right$title$vis = axis === null || axis === void 0 ? void 0 : (_axis$right3 = axis.right) === null || _axis$right3 === void 0 ? void 0 : (_axis$right3$title = _axis$right3.title) === null || _axis$right3$title === void 0 ? void 0 : _axis$right3$title.visible) !== null && _axis$right$title$vis !== void 0 ? _axis$right$title$vis : true
  };
  const tickLabelsVisibilitySettings = (axis === null || axis === void 0 ? void 0 : (_axis$x4 = axis.x) === null || _axis$x4 === void 0 ? void 0 : _axis$x4.ticks) == null && (axis === null || axis === void 0 ? void 0 : (_axis$left4 = axis.left) === null || _axis$left4 === void 0 ? void 0 : _axis$left4.ticks) == null && (axis === null || axis === void 0 ? void 0 : (_axis$right4 = axis.right) === null || _axis$right4 === void 0 ? void 0 : _axis$right4.ticks) == null ? undefined : {
    x: (_axis$x$ticks = axis === null || axis === void 0 ? void 0 : (_axis$x5 = axis.x) === null || _axis$x5 === void 0 ? void 0 : _axis$x5.ticks) !== null && _axis$x$ticks !== void 0 ? _axis$x$ticks : true,
    yLeft: (_axis$left$ticks = axis === null || axis === void 0 ? void 0 : (_axis$left5 = axis.left) === null || _axis$left5 === void 0 ? void 0 : _axis$left5.ticks) !== null && _axis$left$ticks !== void 0 ? _axis$left$ticks : true,
    yRight: (_axis$right$ticks = axis === null || axis === void 0 ? void 0 : (_axis$right5 = axis.right) === null || _axis$right5 === void 0 ? void 0 : _axis$right5.ticks) !== null && _axis$right$ticks !== void 0 ? _axis$right$ticks : true
  };
  const gridlinesVisibilitySettings = (axis === null || axis === void 0 ? void 0 : (_axis$x6 = axis.x) === null || _axis$x6 === void 0 ? void 0 : _axis$x6.grid) == null && (axis === null || axis === void 0 ? void 0 : (_axis$left6 = axis.left) === null || _axis$left6 === void 0 ? void 0 : _axis$left6.grid) == null && (axis === null || axis === void 0 ? void 0 : (_axis$right6 = axis.right) === null || _axis$right6 === void 0 ? void 0 : _axis$right6.grid) == null ? undefined : {
    x: (_axis$x$grid = axis === null || axis === void 0 ? void 0 : (_axis$x7 = axis.x) === null || _axis$x7 === void 0 ? void 0 : _axis$x7.grid) !== null && _axis$x$grid !== void 0 ? _axis$x$grid : true,
    yLeft: (_axis$left$grid = axis === null || axis === void 0 ? void 0 : (_axis$left7 = axis.left) === null || _axis$left7 === void 0 ? void 0 : _axis$left7.grid) !== null && _axis$left$grid !== void 0 ? _axis$left$grid : true,
    yRight: (_axis$right$grid = axis === null || axis === void 0 ? void 0 : (_axis$right7 = axis.right) === null || _axis$right7 === void 0 ? void 0 : _axis$right7.grid) !== null && _axis$right$grid !== void 0 ? _axis$right$grid : true
  };
  const labelsOrientation = (axis === null || axis === void 0 ? void 0 : (_axis$x8 = axis.x) === null || _axis$x8 === void 0 ? void 0 : _axis$x8.label_orientation) == null && (axis === null || axis === void 0 ? void 0 : (_axis$left8 = axis.left) === null || _axis$left8 === void 0 ? void 0 : _axis$left8.label_orientation) == null && (axis === null || axis === void 0 ? void 0 : (_axis$right8 = axis.right) === null || _axis$right8 === void 0 ? void 0 : _axis$right8.label_orientation) == null ? undefined : {
    x: orientationDictionary[(_axis$x$label_orienta = axis === null || axis === void 0 ? void 0 : (_axis$x9 = axis.x) === null || _axis$x9 === void 0 ? void 0 : _axis$x9.label_orientation) !== null && _axis$x$label_orienta !== void 0 ? _axis$x$label_orienta : 'horizontal'],
    yLeft: orientationDictionary[(_axis$left$label_orie = axis === null || axis === void 0 ? void 0 : (_axis$left9 = axis.left) === null || _axis$left9 === void 0 ? void 0 : _axis$left9.label_orientation) !== null && _axis$left$label_orie !== void 0 ? _axis$left$label_orie : 'horizontal'],
    yRight: orientationDictionary[(_axis$right$label_ori = axis === null || axis === void 0 ? void 0 : (_axis$right9 = axis.right) === null || _axis$right9 === void 0 ? void 0 : _axis$right9.label_orientation) !== null && _axis$right$label_ori !== void 0 ? _axis$right$label_ori : 'horizontal']
  };
  const xTitle = axis === null || axis === void 0 ? void 0 : (_axis$x10 = axis.x) === null || _axis$x10 === void 0 ? void 0 : (_axis$x10$title = _axis$x10.title) === null || _axis$x10$title === void 0 ? void 0 : _axis$x10$title.value;
  const yTitle = axis === null || axis === void 0 ? void 0 : (_axis$left10 = axis.left) === null || _axis$left10 === void 0 ? void 0 : (_axis$left10$title = _axis$left10.title) === null || _axis$left10$title === void 0 ? void 0 : _axis$left10$title.value;
  const yRightTitle = axis === null || axis === void 0 ? void 0 : (_axis$right10 = axis.right) === null || _axis$right10 === void 0 ? void 0 : (_axis$right10$title = _axis$right10.title) === null || _axis$right10$title === void 0 ? void 0 : _axis$right10$title.value;
  const yLeftScale = axis === null || axis === void 0 ? void 0 : (_axis$left11 = axis.left) === null || _axis$left11 === void 0 ? void 0 : _axis$left11.scale;
  const yRightScale = axis === null || axis === void 0 ? void 0 : (_axis$right11 = axis.right) === null || _axis$right11 === void 0 ? void 0 : _axis$right11.scale;
  return {
    ...(xTitle && xTitle !== '' ? {
      xTitle
    } : {}),
    ...(yTitle && yTitle !== '' ? {
      yTitle
    } : {}),
    ...(yRightTitle && yRightTitle !== '' ? {
      yRightTitle
    } : {}),
    ...(yLeftScale ? {
      yLeftScale
    } : {}),
    ...(yRightScale ? {
      yRightScale
    } : {}),
    ...(axisTitlesVisibilitySettings ? {
      axisTitlesVisibilitySettings
    } : {}),
    ...(tickLabelsVisibilitySettings ? {
      tickLabelsVisibilitySettings
    } : {}),
    ...(gridlinesVisibilitySettings ? {
      gridlinesVisibilitySettings
    } : {}),
    ...(xExtent ? {
      xExtent
    } : {}),
    ...(yLeftExtent ? {
      yLeftExtent
    } : {}),
    ...(yRightExtent ? {
      yRightExtent
    } : {}),
    ...(labelsOrientation ? {
      labelsOrientation
    } : {})
  };
}
const curveType = {
  linear: 'LINEAR',
  smooth: 'CURVE_MONOTONE_X',
  stepped: 'CURVE_STEP_AFTER'
};
function convertAppearanceToStateFormat(config) {
  var _config$decorations, _config$decorations2, _config$decorations3, _config$decorations4, _config$decorations5, _config$decorations6, _config$decorations7, _config$decorations8;
  return {
    ...(((_config$decorations = config.decorations) === null || _config$decorations === void 0 ? void 0 : _config$decorations.value_labels) != null ? {
      valueLabels: (_config$decorations2 = config.decorations) !== null && _config$decorations2 !== void 0 && _config$decorations2.value_labels ? 'show' : 'hide'
    } : {}),
    ...((_config$decorations3 = config.decorations) !== null && _config$decorations3 !== void 0 && _config$decorations3.line_interpolation ? {
      curveType: curveType[(_config$decorations4 = config.decorations) === null || _config$decorations4 === void 0 ? void 0 : _config$decorations4.line_interpolation]
    } : {}),
    ...(((_config$decorations5 = config.decorations) === null || _config$decorations5 === void 0 ? void 0 : _config$decorations5.fill_opacity) != null ? {
      fillOpacity: (_config$decorations6 = config.decorations) === null || _config$decorations6 === void 0 ? void 0 : _config$decorations6.fill_opacity
    } : {}),
    ...((_config$decorations7 = config.decorations) !== null && _config$decorations7 !== void 0 && _config$decorations7.minimum_bar_height ? {
      minBarHeight: (_config$decorations8 = config.decorations) === null || _config$decorations8 === void 0 ? void 0 : _config$decorations8.minimum_bar_height
    } : {})
  };
}
function buildVisualizationState(config, usedDataViews) {
  var _layers$filter$0$seri, _layers$filter$;
  const layers = config.layers.map((layer, index) => (0, _state_layers.buildXYLayer)(layer, index, usedDataViews[(0, _helpers.getIdForLayer)(layer, index)])).filter(_utils.nonNullable);
  return {
    preferredSeriesType: (_layers$filter$0$seri = (_layers$filter$ = layers.filter(_helpers.isLensStateDataLayer)[0]) === null || _layers$filter$ === void 0 ? void 0 : _layers$filter$.seriesType) !== null && _layers$filter$0$seri !== void 0 ? _layers$filter$0$seri : 'bar_stacked',
    ...(0, _legend.convertLegendToStateFormat)(config.legend),
    ...convertFittingToStateFormat(config.fitting),
    ...convertAxisSettingsToStateFormat(config.axis),
    ...convertAppearanceToStateFormat(config),
    layers
  };
}
function buildVisualizationAPI(config, layers, adHocDataViews, references, internalReferences) {
  const dataLayers = config.layers.filter(_helpers.isLensStateDataLayer);
  if (!dataLayers.length) {
    throw new Error('At least one data layer is required to build the XY API state');
  }
  if (dataLayers.every(layer => layer.accessors.length === 0)) {
    throw new Error('Data layers must have at least one accessor defined to build the XY API state');
  }
  return {
    type: 'xy',
    ...(0, _legend.convertLegendToAPIFormat)(config.legend),
    ...convertFittingToAPIFormat(config),
    ...convertAxisSettingsToAPIFormat(config),
    ...convertAppearanceToAPIFormat(config),
    layers: buildXYLayerAPI(config, layers, adHocDataViews, references, internalReferences)
  };
}
function convertFittingToAPIFormat(config) {
  const fittingOptions = {
    ...(config.fittingFunction ? {
      type: config.fittingFunction.toLowerCase()
    } : {}),
    ...(config.emphasizeFitting ? {
      dotted: config.emphasizeFitting
    } : {}),
    ...(config.endValue ? {
      end_value: config.endValue.toLowerCase()
    } : {})
  };
  if (Object.keys(fittingOptions).length === 0) {
    return {};
  }
  return {
    fitting: fittingOptions
  };
}
function convertExtendsToAPIFormat(extent) {
  if (extent) {
    if (extent.mode === 'full') {
      return {
        extent: {
          type: 'full',
          ...(extent.niceValues != null ? {
            integer_rounding: extent.niceValues
          } : {})
        }
      };
    }
    if (extent.mode === 'custom') {
      if (extent.lowerBound == null || extent.upperBound == null) {
        return {};
      }
      return {
        extent: {
          type: 'custom',
          start: extent.lowerBound,
          end: extent.upperBound,
          ...(extent.niceValues != null ? {
            integer_rounding: extent.niceValues
          } : {})
        }
      };
    }
    if (extent.mode === 'dataBounds') {
      return {
        extent: {
          type: 'focus'
        }
      };
    }
  }
  return {};
}
function convertXExtent(extent) {
  var _xExtent$extent;
  const xExtent = convertExtendsToAPIFormat(extent);
  // focus mode is not compatible with X axis extent
  if (((_xExtent$extent = xExtent.extent) === null || _xExtent$extent === void 0 ? void 0 : _xExtent$extent.type) !== 'focus') {
    // for some reasons TS is not able to infer that here xExtent.extent can't be 'focus'
    // so we need to rewrap it to avoid explicit casting
    return {
      extent: xExtent.extent
    };
  }
  return {};
}
function convertAxisSettingsToAPIFormat(config) {
  var _config$axisTitlesVis, _config$tickLabelsVis, _config$gridlinesVisi, _config$labelsOrienta, _Object$entries$find, _config$axisTitlesVis2, _config$tickLabelsVis2, _config$gridlinesVisi2, _config$labelsOrienta3, _Object$entries$find2, _config$axisTitlesVis3, _config$tickLabelsVis3, _config$gridlinesVisi3, _config$labelsOrienta5, _Object$entries$find3;
  const axis = {};
  const xAxis = {
    ...(config.xTitle ? {
      title: {
        value: config.xTitle,
        ...(((_config$axisTitlesVis = config.axisTitlesVisibilitySettings) === null || _config$axisTitlesVis === void 0 ? void 0 : _config$axisTitlesVis.x) != null ? {
          visible: config.axisTitlesVisibilitySettings.x
        } : {})
      }
    } : {}),
    ...(((_config$tickLabelsVis = config.tickLabelsVisibilitySettings) === null || _config$tickLabelsVis === void 0 ? void 0 : _config$tickLabelsVis.x) != null ? {
      ticks: config.tickLabelsVisibilitySettings.x
    } : {}),
    ...(((_config$gridlinesVisi = config.gridlinesVisibilitySettings) === null || _config$gridlinesVisi === void 0 ? void 0 : _config$gridlinesVisi.x) != null ? {
      grid: config.gridlinesVisibilitySettings.x
    } : {}),
    ...convertXExtent(config.xExtent),
    ...(((_config$labelsOrienta = config.labelsOrientation) === null || _config$labelsOrienta === void 0 ? void 0 : _config$labelsOrienta.x) != null ? {
      label_orientation: (_Object$entries$find = Object.entries(orientationDictionary).find(([_, value]) => {
        var _config$labelsOrienta2;
        return value === ((_config$labelsOrienta2 = config.labelsOrientation) === null || _config$labelsOrienta2 === void 0 ? void 0 : _config$labelsOrienta2.x);
      })) === null || _Object$entries$find === void 0 ? void 0 : _Object$entries$find[0]
    } : {})
  };
  if (Object.keys(xAxis).length) {
    axis.x = xAxis;
  }
  const leftAxis = {
    ...(config.yTitle ? {
      title: {
        value: config.yTitle,
        ...(((_config$axisTitlesVis2 = config.axisTitlesVisibilitySettings) === null || _config$axisTitlesVis2 === void 0 ? void 0 : _config$axisTitlesVis2.yLeft) != null ? {
          visible: config.axisTitlesVisibilitySettings.yLeft
        } : {})
      }
    } : {}),
    ...(config.yLeftScale ? {
      scale: config.yLeftScale
    } : {}),
    ...(((_config$tickLabelsVis2 = config.tickLabelsVisibilitySettings) === null || _config$tickLabelsVis2 === void 0 ? void 0 : _config$tickLabelsVis2.yLeft) != null ? {
      ticks: config.tickLabelsVisibilitySettings.yLeft
    } : {}),
    ...(((_config$gridlinesVisi2 = config.gridlinesVisibilitySettings) === null || _config$gridlinesVisi2 === void 0 ? void 0 : _config$gridlinesVisi2.yLeft) != null ? {
      grid: config.gridlinesVisibilitySettings.yLeft
    } : {}),
    ...convertExtendsToAPIFormat(config.yLeftExtent),
    ...(((_config$labelsOrienta3 = config.labelsOrientation) === null || _config$labelsOrienta3 === void 0 ? void 0 : _config$labelsOrienta3.yLeft) != null ? {
      label_orientation: (_Object$entries$find2 = Object.entries(orientationDictionary).find(([_, value]) => {
        var _config$labelsOrienta4;
        return value === ((_config$labelsOrienta4 = config.labelsOrientation) === null || _config$labelsOrienta4 === void 0 ? void 0 : _config$labelsOrienta4.yLeft);
      })) === null || _Object$entries$find2 === void 0 ? void 0 : _Object$entries$find2[0]
    } : {})
  };
  if (Object.keys(leftAxis).length) {
    axis.left = leftAxis;
  }
  const rightAxis = {
    ...(config.yRightTitle ? {
      title: {
        value: config.yRightTitle,
        ...(((_config$axisTitlesVis3 = config.axisTitlesVisibilitySettings) === null || _config$axisTitlesVis3 === void 0 ? void 0 : _config$axisTitlesVis3.yRight) != null ? {
          visible: config.axisTitlesVisibilitySettings.yRight
        } : {})
      }
    } : {}),
    ...(config.yRightScale ? {
      scale: config.yRightScale
    } : {}),
    ...(((_config$tickLabelsVis3 = config.tickLabelsVisibilitySettings) === null || _config$tickLabelsVis3 === void 0 ? void 0 : _config$tickLabelsVis3.yRight) != null ? {
      ticks: config.tickLabelsVisibilitySettings.yRight
    } : {}),
    ...(((_config$gridlinesVisi3 = config.gridlinesVisibilitySettings) === null || _config$gridlinesVisi3 === void 0 ? void 0 : _config$gridlinesVisi3.yRight) != null ? {
      grid: config.gridlinesVisibilitySettings.yRight
    } : {}),
    ...convertExtendsToAPIFormat(config.yRightExtent),
    ...(((_config$labelsOrienta5 = config.labelsOrientation) === null || _config$labelsOrienta5 === void 0 ? void 0 : _config$labelsOrienta5.yRight) != null ? {
      label_orientation: (_Object$entries$find3 = Object.entries(orientationDictionary).find(([_, value]) => {
        var _config$labelsOrienta6;
        return value === ((_config$labelsOrienta6 = config.labelsOrientation) === null || _config$labelsOrienta6 === void 0 ? void 0 : _config$labelsOrienta6.yRight);
      })) === null || _Object$entries$find3 === void 0 ? void 0 : _Object$entries$find3[0]
    } : {})
  };
  if (Object.keys(rightAxis).length) {
    axis.right = rightAxis;
  }
  if (['x', 'left', 'right'].every(dir => !(dir in axis))) {
    return {};
  }
  return {
    axis
  };
}
function convertAppearanceToAPIFormat(config) {
  var _Object$entries$find4;
  const decorations = {
    ...(config.valueLabels != null ? {
      value_labels: config.valueLabels === 'show'
    } : {}),
    ...(config.curveType ? {
      line_interpolation: ((_Object$entries$find4 = Object.entries(curveType).find(([_, value]) => value === config.curveType)) === null || _Object$entries$find4 === void 0 ? void 0 : _Object$entries$find4[0]) || 'linear'
    } : {}),
    ...(config.fillOpacity != null ? {
      fill_opacity: config.fillOpacity
    } : {}),
    ...(config.minBarHeight != null ? {
      minimum_bar_height: config.minBarHeight
    } : {})
  };
  if (Object.keys(decorations).length === 0) {
    return {};
  }
  return {
    decorations
  };
}
function buildXYLayerAPI(visualization, layers, adHocDataViews, references, adhocReferences) {
  const apiLayers = [];
  for (const visLayer of visualization.layers) {
    if (visLayer.layerType === 'referenceLine') {
      const datasourceLayer = layers[visLayer.layerId];
      if ((0, _utils.isFormBasedLayer)(datasourceLayer) || (0, _utils.isTextBasedLayer)(datasourceLayer)) {
        apiLayers.push((0, _api_layers.buildAPIReferenceLinesLayer)(visLayer, datasourceLayer, adHocDataViews, references, adhocReferences));
      }
    }
    if ((0, _helpers.isLensStateDataLayer)(visLayer)) {
      const datasourceLayer = layers[visLayer.layerId];
      if (datasourceLayer && ((0, _utils.isFormBasedLayer)(datasourceLayer) || (0, _utils.isTextBasedLayer)(datasourceLayer))) {
        apiLayers.push((0, _api_layers.buildAPIDataLayer)(visLayer, datasourceLayer, adHocDataViews, references, adhocReferences));
      }
    }
    if (visLayer.layerType === 'annotations') {
      apiLayers.push((0, _api_layers.buildAPIAnnotationsLayer)(visLayer, adHocDataViews, references, adhocReferences));
    }
  }
  return apiLayers;
}