"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializedValueSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const rangeValueSchema = _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]);
const rangeKeySchema = _configSchema.schema.object({
  type: _configSchema.schema.literal('RangeKey'),
  from: rangeValueSchema,
  to: rangeValueSchema,
  ranges: _configSchema.schema.arrayOf(_configSchema.schema.object({
    from: rangeValueSchema,
    to: rangeValueSchema,
    label: _configSchema.schema.string()
  }))
});
const multiFieldKeySchema = _configSchema.schema.object({
  type: _configSchema.schema.literal('multiFieldKey'),
  keys: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const serializedValueSchema = exports.serializedValueSchema = _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number(), rangeKeySchema, multiFieldKeySchema]);