"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensApiStateSchema = exports._lensApiStateSchema = void 0;
Object.defineProperty(exports, "tagcloudStateSchema", {
  enumerable: true,
  get: function () {
    return _tagcloud.tagcloudStateSchema;
  }
});
var _configSchema = require("@kbn/config-schema");
var _metric = require("./charts/metric");
var _legacy_metric = require("./charts/legacy_metric");
var _gauge = require("./charts/gauge");
var _tagcloud = require("./charts/tagcloud");
var _xy = require("./charts/xy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * We need to break the type inference here to avoid exceeding the ts compiler serialization limit.
 *
 * This requires:
 *  - Casting the schema as any
 *  - Defining the `LensApiState` type from the schema types
 *  - Exporting this value as `Type<LensApiState>`
 */
const _lensApiStateSchema = exports._lensApiStateSchema = _configSchema.schema.oneOf([_metric.metricStateSchema, _legacy_metric.legacyMetricStateSchema, _xy.xyStateSchema, _gauge.gaugeStateSchema, _tagcloud.tagcloudStateSchema]);
const lensApiStateSchema = exports.lensApiStateSchema = _lensApiStateSchema;