"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildXY = buildXY;
var _columns = require("../columns");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'metric_formula_accessor';
function buildVisualizationState(config) {
  var _config$axisTitleVisi, _config$axisTitleVisi2, _config$axisTitleVisi3, _config$axisTitleVisi4, _config$axisTitleVisi5, _config$axisTitleVisi6, _config$legend$show, _config$legend, _config$legend$positi, _config$legend2, _config$legend3, _config$valueLabels, _config$emphasizeFitt, _config$fittingFuncti, _config$yBounds$mode, _config$yBounds, _config$yBounds2, _config$yBounds3;
  return {
    axisTitlesVisibilitySettings: {
      x: (_config$axisTitleVisi = (_config$axisTitleVisi2 = config.axisTitleVisibility) === null || _config$axisTitleVisi2 === void 0 ? void 0 : _config$axisTitleVisi2.showXAxisTitle) !== null && _config$axisTitleVisi !== void 0 ? _config$axisTitleVisi : true,
      yLeft: (_config$axisTitleVisi3 = (_config$axisTitleVisi4 = config.axisTitleVisibility) === null || _config$axisTitleVisi4 === void 0 ? void 0 : _config$axisTitleVisi4.showYAxisTitle) !== null && _config$axisTitleVisi3 !== void 0 ? _config$axisTitleVisi3 : true,
      yRight: (_config$axisTitleVisi5 = (_config$axisTitleVisi6 = config.axisTitleVisibility) === null || _config$axisTitleVisi6 === void 0 ? void 0 : _config$axisTitleVisi6.showYRightAxisTitle) !== null && _config$axisTitleVisi5 !== void 0 ? _config$axisTitleVisi5 : true
    },
    legend: {
      isVisible: (_config$legend$show = (_config$legend = config.legend) === null || _config$legend === void 0 ? void 0 : _config$legend.show) !== null && _config$legend$show !== void 0 ? _config$legend$show : true,
      position: (_config$legend$positi = (_config$legend2 = config.legend) === null || _config$legend2 === void 0 ? void 0 : _config$legend2.position) !== null && _config$legend$positi !== void 0 ? _config$legend$positi : 'left',
      ...((_config$legend3 = config.legend) !== null && _config$legend3 !== void 0 && _config$legend3.legendStats ? {
        legendStats: config.legend.legendStats
      } : {})
    },
    hideEndzones: true,
    preferredSeriesType: 'line',
    valueLabels: (_config$valueLabels = config.valueLabels) !== null && _config$valueLabels !== void 0 ? _config$valueLabels : 'hide',
    emphasizeFitting: (_config$emphasizeFitt = config === null || config === void 0 ? void 0 : config.emphasizeFitting) !== null && _config$emphasizeFitt !== void 0 ? _config$emphasizeFitt : true,
    fittingFunction: (_config$fittingFuncti = config === null || config === void 0 ? void 0 : config.fittingFunction) !== null && _config$fittingFuncti !== void 0 ? _config$fittingFuncti : 'Linear',
    yLeftExtent: {
      mode: (_config$yBounds$mode = (_config$yBounds = config.yBounds) === null || _config$yBounds === void 0 ? void 0 : _config$yBounds.mode) !== null && _config$yBounds$mode !== void 0 ? _config$yBounds$mode : 'full',
      lowerBound: (_config$yBounds2 = config.yBounds) === null || _config$yBounds2 === void 0 ? void 0 : _config$yBounds2.lowerBound,
      upperBound: (_config$yBounds3 = config.yBounds) === null || _config$yBounds3 === void 0 ? void 0 : _config$yBounds3.upperBound
    },
    tickLabelsVisibilitySettings: {
      x: true,
      yLeft: true,
      yRight: true
    },
    labelsOrientation: {
      x: 0,
      yLeft: 0,
      yRight: 0
    },
    gridlinesVisibilitySettings: {
      x: true,
      yLeft: true,
      yRight: true
    },
    layers: config.layers.map((layer, i) => {
      switch (layer.type) {
        case 'annotation':
          return {
            layerId: `layer_${i}`,
            layerType: 'annotations',
            annotations: layer.events.map((e, eventNr) => {
              if ('datetime' in e) {
                return {
                  type: 'manual',
                  id: `annotation_${eventNr}`,
                  icon: e.icon || 'triangle',
                  color: e.color || 'blue',
                  label: e.name,
                  key: {
                    type: 'point_in_time',
                    timestamp: e.datetime
                  }
                };
              } else {
                return {
                  id: `event${eventNr}`,
                  type: 'query',
                  icon: e.icon || 'triangle',
                  color: e.color || 'blue',
                  label: e.name,
                  key: {
                    type: 'point_in_time'
                  },
                  filter: {
                    type: 'kibana_query',
                    query: e.filter,
                    language: 'kuery'
                  },
                  ...(e.field ? {
                    timeField: e.field
                  } : {})
                };
              }
            }),
            ignoreGlobalFilters: true
          };
        case 'reference':
          return {
            layerId: `layer_${i}`,
            layerType: 'referenceLine',
            accessors: layer.yAxis.map((_, index) => `${ACCESSOR}${i}_${index}`),
            yConfig: layer.yAxis.map((yAxis, index) => ({
              forAccessor: `${ACCESSOR}${i}_${index}`,
              axisMode: 'left',
              color: yAxis.seriesColor,
              ...(yAxis.fill ? {
                fill: yAxis.fill
              } : {}),
              ...(yAxis.lineThickness ? {
                lineWidth: yAxis.lineThickness
              } : {})
            }))
          };
        case 'series':
          return {
            layerId: `layer_${i}`,
            layerType: 'data',
            xAccessor: `x_${ACCESSOR}${i}`,
            ...(layer.breakdown ? {
              splitAccessor: `${ACCESSOR}${i}_breakdown`
            } : {}),
            accessors: layer.yAxis.map((_, index) => `${ACCESSOR}${i}_${index}`),
            seriesType: layer.seriesType || 'line',
            yConfig: layer.yAxis.map((yAxis, index) => ({
              forAccessor: `${ACCESSOR}${i}_${index}`,
              color: yAxis.seriesColor
            }))
          };
      }
    })
  };
}
function hasFormatParams(yAxis) {
  return yAxis.format && (yAxis.suffix || yAxis.compactValues || yAxis.decimals || yAxis.fromUnit || yAxis.toUnit);
}
function getValueColumns(layer, i) {
  if (layer.breakdown && typeof layer.breakdown !== 'string') {
    throw new Error('`breakdown` must be a field name when not using index source');
  }
  return [...(layer.breakdown ? [(0, _columns.getValueColumn)(`${ACCESSOR}${i}_breakdown`, layer.breakdown)] : []), ...getXValueColumn(layer.xAxis, i), ...layer.yAxis.map((yAxis, index) => {
    var _yAxis$decimals;
    const params = hasFormatParams(yAxis) ? {
      id: yAxis.format,
      params: {
        compact: yAxis.compactValues,
        decimals: (_yAxis$decimals = yAxis.decimals) !== null && _yAxis$decimals !== void 0 ? _yAxis$decimals : 0,
        suffix: yAxis.suffix,
        fromUnit: yAxis.fromUnit,
        toUnit: yAxis.toUnit
      }
    } : undefined;
    return (0, _columns.getValueColumn)(`${ACCESSOR}${i}_${index}`, yAxis.value, 'number', params);
  })];
}
function getXValueColumn(xConfig, index) {
  if (!xConfig) {
    return [];
  }
  const accessor = `x_${ACCESSOR}${index}`;
  if (typeof xConfig === 'string') {
    return [(0, _columns.getValueColumn)(accessor, xConfig)];
  }
  switch (xConfig.type) {
    case 'dateHistogram':
      return [(0, _columns.getValueColumn)(accessor, xConfig.field, 'date')];
    case 'intervals':
      return [(0, _columns.getValueColumn)(accessor, xConfig.field, 'number')];
    case 'topValues':
      return [(0, _columns.getValueColumn)(accessor, xConfig.field)];
    case 'filters':
      throw new Error('Not implemented yet');
  }
}
function buildAllFormulasInLayer(layer, i, dataView) {
  return layer.yAxis.reduce((acc, curr, valueIndex) => {
    const formulaColumn = (0, _columns.getFormulaColumn)(`${ACCESSOR}${i}_${valueIndex}`, (0, _utils.mapToFormula)(curr), dataView, valueIndex > 0 ? acc : undefined);
    return {
      ...acc,
      ...formulaColumn
    };
  }, {});
}
function buildFormulaLayer(layer, i, dataView) {
  if (layer.type === 'series') {
    const resultLayer = buildAllFormulasInLayer(layer, i, dataView);
    if (layer.xAxis) {
      const columnName = `x_${ACCESSOR}${i}`;
      const breakdownColumn = (0, _columns.getBreakdownColumn)({
        options: layer.xAxis,
        dataView
      });
      (0, _utils.addLayerColumn)(resultLayer, columnName, breakdownColumn, true);
    }
    if (layer.breakdown) {
      const columnName = `${ACCESSOR}${i}_breakdown`;
      const breakdownColumn = (0, _columns.getBreakdownColumn)({
        options: layer.breakdown,
        dataView
      });
      (0, _utils.addLayerColumn)(resultLayer, columnName, breakdownColumn, true);
    }
    return resultLayer;
  } else if (layer.type === 'annotation') {
    // nothing ?
  } else if (layer.type === 'reference') {
    return buildAllFormulasInLayer(layer, i, dataView);
  }
  return {
    columns: {},
    columnOrder: []
  };
}
async function buildXY(config, {
  dataViewsAPI
}) {
  const dataviews = {};
  const _buildFormulaLayer = (cfg, i, dataView) => buildFormulaLayer(cfg, i, dataView);
  const datasourceStates = await (0, _utils.buildDatasourceStates)(config, dataviews, _buildFormulaLayer, getValueColumns, dataViewsAPI);
  const {
    references,
    internalReferences,
    adHocDataViews
  } = (0, _utils.extractReferences)(dataviews);
  return {
    title: config.title,
    visualizationType: 'lnsXY',
    references,
    state: {
      datasourceStates,
      internalReferences,
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: buildVisualizationState(config),
      adHocDataViews
    }
  };
}