"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiTheme = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Not all Eui Tokens were fully migrated to @elastic/eui/useEuiTheme yet, so
// this hook overrides the default useEuiTheme hook to provide a custom hook that
// allows the use the euiVars tokens from the euiLightVars and euiDarkVars
const useEuiTheme = (...props) => {
  const euiThemeHook = (0, _eui.useEuiTheme)(...props);
  const euiVars = (0, _react.useMemo)(() => {
    const themeVars = euiThemeHook.colorMode === 'DARK' ? _uiTheme.euiDarkVars : _uiTheme.euiLightVars;
    const extraEuiVars = {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      euiColorVis6_asText: (0, _eui.shade)(themeVars.euiColorVis6, 0.335),
      buttonsBackgroundNormalDefaultPrimary: '#006DE4'
    };
    return {
      ...themeVars,
      ...extraEuiVars
    };
  }, [euiThemeHook.colorMode]);
  return {
    ...euiThemeHook,
    euiVars
  };
};
exports.useEuiTheme = useEuiTheme;