"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricComparison = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/single_metric_comparison.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SingleMetricComparison = ({
  currentValue,
  previousValue
}) => {
  const changeFactor = currentValue / previousValue - 1;
  if (changeFactor < 0) {
    return /*#__PURE__*/_react.default.createElement(NoWrapSpan, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortDown",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, formatPercentage(changeFactor)));
  } else if (changeFactor > 0 && Number.isFinite(changeFactor)) {
    return /*#__PURE__*/_react.default.createElement(NoWrapSpan, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortUp",
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }, formatPercentage(changeFactor)));
  } else if (changeFactor > 0 && !Number.isFinite(changeFactor)) {
    return /*#__PURE__*/_react.default.createElement(NoWrapSpan, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortUp",
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }, newCategoryTrendLabel));
  }
  return null;
};
exports.SingleMetricComparison = SingleMetricComparison;
const formatPercentage = value => (0, _numeral.default)(value).format('+0,0 %');
const newCategoryTrendLabel = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.newCategoryTrendLabel', {
  defaultMessage: 'new'
});
const NoWrapSpan = _styled.default.span`
  white-space: nowrap;
`;