"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionDropDown = exports.ClosablePopoverTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/inventory/components/expression_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExpressionDropDown = ({
  value,
  options,
  onChange,
  popupPosition,
  description,
  popoverTitle,
  ...props
}) => {
  const [popoverOpen, {
    toggle: togglePopover,
    off: closePopover
  }] = (0, _reactHooks.useBoolean)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "nodeTypeExpression",
      description: description,
      value: options[value].text,
      isActive: popoverOpen,
      onClick: togglePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }),
    isOpen: popoverOpen,
    closePopover: closePopover,
    ownFocus: true,
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    onBlur: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ClosablePopoverTitle, {
    onClose: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, popoverTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": props['aria-label'],
    "data-test-subj": props['data-test-subj'],
    value: value,
    fullWidth: true,
    onChange: e => {
      onChange(e.target.value);
      closePopover();
    },
    options: Object.values(options).map(o => o),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  })));
};
exports.ExpressionDropDown = ExpressionDropDown;
const ClosablePopoverTitle = ({
  children,
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraClosablePopoverTitleButton",
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel', {
      defaultMessage: 'Close'
    }),
    onClick: () => onClose(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }))));
};
exports.ClosablePopoverTitle = ClosablePopoverTitle;