"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateReasoningPrompts = generateReasoningPrompts;
var _mustache = _interopRequireDefault(require("mustache"));
var _low_power_meta_prompt = _interopRequireDefault(require("./prompts/low_power_meta_prompt.text"));
var _medium_power_meta_prompt = _interopRequireDefault(require("./prompts/medium_power_meta_prompt.text"));
var _high_power_meta_prompt = _interopRequireDefault(require("./prompts/high_power_meta_prompt.text"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function generateReasoningPrompts({
  taskDescriptionTemplate,
  inferenceClient
}) {
  const powers = ['low', 'medium', 'high'];
  const prompts = [_low_power_meta_prompt.default, _medium_power_meta_prompt.default, _high_power_meta_prompt.default];
  const indices = Object.fromEntries(powers.map((power, idx) => [power, idx]));
  const outputs = await Promise.all(powers.map(async power => {
    const powerIndex = powers.indexOf(power);
    const view = {
      atLeastMediumPower: powerIndex >= indices.medium,
      atMostMediumPower: powerIndex <= indices.medium,
      lowPower: powerIndex === indices.low,
      mediumPower: powerIndex === indices.medium,
      highPower: powerIndex === indices.high
    };
    const prompt = [prompts[powerIndex]].join();
    const input = [prompt, _mustache.default.render(taskDescriptionTemplate, view), `Do not preface your output with any intro or summary. Directly output the prompt. Do not create a distinction between a user and a system prompt.`].join('\n\n');
    const response = await inferenceClient.output({
      id: `generate_${power}_power_system_prompt`,
      input
    });
    return response.content;
  }));
  return powers.map(power => {
    return `{{#power.${power}}}\n\n${outputs[indices[power]]}\n\n{{/power.${power}}}`;
  }).join('\n\n');
}