"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemperatureIfValid = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPENAI_MODELS_WITHOUT_TEMPERATURE = ['o1', 'o3', 'gpt-5'];
const getTemperatureIfValid = (temperature, {
  connector,
  modelName
} = {}) => {
  var _connector$config, _ref, _connector$config2, _connector$config2$pr, _connector$config3;
  // If user sets temperature in the connector config, use it by default
  if (connector !== null && connector !== void 0 && (_connector$config = connector.config) !== null && _connector$config !== void 0 && _connector$config.temperature) {
    return {
      temperature: connector.config.temperature
    };
  }
  if (temperature === undefined || temperature < 0) return {};

  // Else, use the temperature from the request
  const model = (_ref = modelName !== null && modelName !== void 0 ? modelName : connector === null || connector === void 0 ? void 0 : (_connector$config2 = connector.config) === null || _connector$config2 === void 0 ? void 0 : (_connector$config2$pr = _connector$config2.providerConfig) === null || _connector$config2$pr === void 0 ? void 0 : _connector$config2$pr.model_id) !== null && _ref !== void 0 ? _ref : connector === null || connector === void 0 ? void 0 : (_connector$config3 = connector.config) === null || _connector$config3 === void 0 ? void 0 : _connector$config3.defaultModel;
  if (((connector === null || connector === void 0 ? void 0 : connector.type) === _inferenceCommon.InferenceConnectorType.OpenAI || (connector === null || connector === void 0 ? void 0 : connector.type) === _inferenceCommon.InferenceConnectorType.Inference) && model) {
    const normalizedModelName = model.toLowerCase();
    const shouldExcludeTemperature = OPENAI_MODELS_WITHOUT_TEMPERATURE.some(
    //  e.g openai/gpt-5 or gpt-5-xxx
    m => normalizedModelName.startsWith(m) || normalizedModelName.endsWith(m));
    return shouldExcludeTemperature ? {} : {
      temperature
    };
  }
  return {
    temperature
  };
};
exports.getTemperatureIfValid = getTemperatureIfValid;