"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _semver = require("semver");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kibanaVersion = new _semver.SemVer(_constants.MAJOR_VERSION);

// -------------------------------
// >= 8.x
// -------------------------------
const schemaLatest = _configSchema.schema.object({
  ui: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableIndexActions: (0, _configSchema.offeringBasedSchema)({
    // Index actions are disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableLegacyTemplates: (0, _configSchema.offeringBasedSchema)({
    // Legacy templates functionality is disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  dev: _configSchema.schema.object({
    // deprecated as unused after index details page has been implemented
    enableIndexDetailsPage: _configSchema.schema.boolean({
      defaultValue: false
    }),
    // deprecate as unused after semantic text is enabled everywhere
    enableSemanticText: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableSizeAndDocCount: (0, _configSchema.offeringBasedSchema)({
    // Size and document count information is enabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableIndexStats: (0, _configSchema.offeringBasedSchema)({
    // Index stats information is disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableDataStreamStats: (0, _configSchema.offeringBasedSchema)({
    // Data stream stats information is disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  editableIndexSettings: (0, _configSchema.offeringBasedSchema)({
    // on serverless only a limited set of index settings can be edited
    serverless: _configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('limited')], {
      defaultValue: 'all'
    })
  }),
  enableMappingsSourceFieldSection: (0, _configSchema.offeringBasedSchema)({
    // The _source field in the Mappings editor's advanced options form is disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableTogglingDataRetention: (0, _configSchema.offeringBasedSchema)({
    // The toggle for enabling data retention for DSL in data streams UI is disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableProjectLevelRetentionChecks: (0, _configSchema.offeringBasedSchema)({
    // Max project level retention checks is enabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  enableFailureStoreRetentionDisabling: (0, _configSchema.offeringBasedSchema)({
    // Failure store lifecycle can not be disabled in serverless; refer to the serverless.yml file as the source of truth
    // We take this approach in order to have a central place (serverless.yml) for serverless config across Kibana
    serverless: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
}, {
  defaultValue: undefined
});
const configLatest = {
  exposeToBrowser: {
    ui: true,
    dev: {
      enableSemanticText: true
    },
    enableIndexActions: true,
    enableLegacyTemplates: true,
    enableIndexStats: true,
    enableDataStreamStats: true,
    enableSizeAndDocCount: true,
    editableIndexSettings: true,
    enableMappingsSourceFieldSection: true,
    enableTogglingDataRetention: true,
    enableProjectLevelRetentionChecks: true,
    enableFailureStoreRetentionDisabling: true
  },
  schema: schemaLatest,
  deprecations: ({
    unused
  }) => [unused('dev.enableIndexDetailsPage', {
    level: 'warning'
  })]
};
// -------------------------------
// 7.x
// -------------------------------
const schema7x = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  ui: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
}, {
  defaultValue: undefined
});
const config7x = {
  exposeToBrowser: {
    ui: true
  },
  schema: schema7x,
  deprecations: () => [(completeConfig, rootPath, addDeprecation) => {
    if ((0, _lodash.get)(completeConfig, 'xpack.index_management.enabled') === undefined) {
      return completeConfig;
    }
    addDeprecation({
      configPath: 'xpack.index_management.enabled',
      level: 'critical',
      title: _i18n.i18n.translate('xpack.idxMgmt.deprecations.enabledTitle', {
        defaultMessage: 'Setting "xpack.index_management.enabled" is deprecated'
      }),
      message: _i18n.i18n.translate('xpack.idxMgmt.deprecations.enabledMessage', {
        defaultMessage: 'To disallow users from accessing the Index Management UI, use the "xpack.index_management.ui.enabled" setting instead of "xpack.index_management.enabled".'
      }),
      correctiveActions: {
        manualSteps: [_i18n.i18n.translate('xpack.idxMgmt.deprecations.enabled.manualStepOneMessage', {
          defaultMessage: 'Open the kibana.yml config file.'
        }), _i18n.i18n.translate('xpack.idxMgmt.deprecations.enabled.manualStepTwoMessage', {
          defaultMessage: 'Change the "xpack.index_management.enabled" setting to "xpack.index_management.ui.enabled".'
        })]
      }
    });
    return completeConfig;
  }]
};
const config = exports.config = kibanaVersion.major < 8 ? config7x : configLatest;