"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalHost = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _convert_to_lookup_index_modal_container = require("../../details_page/convert_to_lookup_index_modal/convert_to_lookup_index_modal_container");
var _routing = require("../../../../../services/routing");
var _notification = require("../../../../../services/notification");
var _constants = require("../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/index_actions_context_menu/modal_host/modal_host.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const initialModalState = {
  kind: 'none',
  forcemergeSegments: null
};
function modalReducer(state, action) {
  switch (action.type) {
    case 'OPEN':
      switch (action.payload.kind) {
        case 'forcemerge':
          return {
            kind: 'forcemerge',
            forcemergeSegments: null
          };
        case 'delete':
          return {
            kind: 'delete',
            forcemergeSegments: null
          };
        case 'convertToLookup':
          return {
            kind: 'convertToLookup',
            forcemergeSegments: null
          };
        case 'extension':
          return {
            kind: 'extension',
            actionIndex: action.payload.actionIndex,
            forcemergeSegments: null
          };
      }
    case 'CLOSE':
      return {
        kind: 'none',
        forcemergeSegments: null
      };
    case 'SET_FORCE_SEGMENTS':
      return {
        ...state,
        forcemergeSegments: action.value
      };
    default:
      return state;
  }
}
const ModalHost = exports.ModalHost = /*#__PURE__*/(0, _react.memo)(/*#__PURE__*/(0, _react.forwardRef)(function ModalHost({
  indexNames,
  indices,
  indicesListURLParams,
  resetSelection,
  forcemergeIndices,
  deleteIndices,
  reloadIndices,
  extensionsService,
  getUrlForApp,
  application,
  http
}, ref) {
  const [state, dispatch] = (0, _react.useReducer)(modalReducer, initialModalState);
  (0, _react.useImperativeHandle)(ref, () => ({
    openModal: req => dispatch({
      type: 'OPEN',
      payload: req
    }),
    closeModal: () => dispatch({
      type: 'CLOSE'
    })
  }));
  const closeConfirmModal = () => {
    dispatch({
      type: 'CLOSE'
    });
    resetSelection === null || resetSelection === void 0 ? void 0 : resetSelection();
  };
  const forcemergeSegmentsError = () => {
    const value = state.forcemergeSegments;
    if (!value || value.match(/^([1-9][0-9]*)?$/)) {
      return;
    }
    return _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.segmentsNumberErrorMessage', {
      defaultMessage: 'The number of segments must be greater than zero.'
    });
  };
  const renderForcemergeSegmentsModal = () => {
    const helpText = _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeSegmentsHelpText', {
      defaultMessage: 'Merge the segments in an index until the number is reduced to this or fewer segments. The default is 1.'
    });
    const selectedIndexCount = indexNames.length;
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.modalTitle', {
        defaultMessage: 'Force merge'
      }),
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: closeConfirmModal,
      onConfirm: () => {
        const error = forcemergeSegmentsError();
        if (!error) {
          const value = state.forcemergeSegments && state.forcemergeSegments.trim() !== '' ? state.forcemergeSegments : '1';
          forcemergeIndices(value);
          dispatch({
            type: 'CLOSE'
          });
          resetSelection === null || resetSelection === void 0 ? void 0 : resetSelection();
        }
      },
      cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.cancelButtonText', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.confirmButtonText', {
        defaultMessage: 'Force merge'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeDescription",
      defaultMessage: "You are about to force merge {selectedIndexCount, plural, one {this index} other {these indices} }:",
      values: {
        selectedIndexCount
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 11
      }
    }, indexNames.map(indexName => /*#__PURE__*/_react.default.createElement("li", {
      key: indexName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    }, indexName))), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.proceedWithCautionCallOutTitle', {
        defaultMessage: 'Proceed with caution!'
      }),
      color: "warning",
      iconType: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeWarningDescription",
      defaultMessage: " Don't force-merge indices to which you're still writing, or to which you'll write again in the future. Instead, rely on the automatic background merge process to perform merges as needed to keep the index running smoothly. If you write to a force-merged index then its performance may become much worse. ",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      isInvalid: !!forcemergeSegmentsError(),
      error: forcemergeSegmentsError(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.maximumNumberOfSegmentsFormRowLabel', {
        defaultMessage: 'Maximum number of segments per shard'
      }),
      helpText: helpText,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "indexActionsForcemergeNumSegments",
      onChange: event => {
        dispatch({
          type: 'SET_FORCE_SEGMENTS',
          value: event.target.value
        });
      },
      min: 1,
      name: "maxNumberSegments",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 15
      }
    }))));
  };
  const renderConfirmDeleteModal = () => {
    const selectedIndexCount = indexNames.length;
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    const standardIndexModalBody = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexActionsMenu.deleteIndex.deleteDescription",
      defaultMessage: "You are about to delete {selectedIndexCount, plural, one {this index} other {these indices} }:",
      values: {
        selectedIndexCount
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 11
      }
    }, indexNames.map(indexName => /*#__PURE__*/_react.default.createElement("li", {
      key: indexName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 15
      }
    }, indexName))), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexActionsMenu.deleteIndex.deleteWarningDescription",
      defaultMessage: "You can't recover a deleted index. Make sure you have appropriate backups. Deleting an index currently being reindexed will stop the reindex operation.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 13
      }
    })));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.modalTitle', {
        defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {# indices} }',
        values: {
          selectedIndexCount
        }
      }),
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: () => {
        closeConfirmModal();
      },
      onConfirm: () => {
        deleteIndices();
        closeConfirmModal();
      },
      buttonColor: "danger",
      confirmButtonDisabled: false,
      cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.cancelButtonText', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.confirmButtonText', {
        defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {indices} }',
        values: {
          selectedIndexCount
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 9
      }
    }, standardIndexModalBody);
  };
  const renderConvertToLookupIndexModal = () => {
    const sourceIndexName = indexNames[0];
    return /*#__PURE__*/_react.default.createElement(_convert_to_lookup_index_modal_container.ConvertToLookupIndexModalContainer, {
      onCloseModal: () => closeConfirmModal(),
      onSuccess: lookupIndexName => {
        (0, _routing.navigateToIndexDetailsPage)(lookupIndexName, indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Overview);
        _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexAction.indexConvertedToastTitle', {
          defaultMessage: 'Index successfully converted to lookup mode'
        }), _i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexAction.indexConvertedToastMessage', {
          defaultMessage: 'The {lookupIndexName} lookup index has been created.',
          values: {
            lookupIndexName
          }
        }));
      },
      sourceIndexName: sourceIndexName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 9
      }
    });
  };
  const renderExtensionModal = () => {
    if (state.kind !== 'extension') return null;
    const actionFactory = extensionsService.actions[state.actionIndex];
    if (!actionFactory) return null;
    const actionDef = actionFactory({
      indices,
      reloadIndices,
      getUrlForApp
    });
    return actionDef !== null && actionDef !== void 0 && actionDef.renderConfirmModal ? actionDef.renderConfirmModal(closeConfirmModal) : null;
  };
  if (state.kind === 'forcemerge') return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderForcemergeSegmentsModal());
  if (state.kind === 'delete') return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderConfirmDeleteModal());
  if (state.kind === 'convertToLookup') return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderConvertToLookupIndexModal());
  if (state.kind === 'extension') return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderExtensionModal());
  return null;
}));