"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutePolicyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../services/api");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/enrich_policies_list/confirm_modals/execute_policy_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExecutePolicyModal = ({
  policyToExecute,
  callback
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const mounted = (0, _react.useRef)(false);
  const {
    services: {
      notificationService
    }
  } = (0, _app_context.useAppContext)();
  const [isExecuting, setIsExecuting] = (0, _react.useState)(false);

  // Since the async action of this component needs to set state after unmounting,
  // we need to track the mounted state of this component to avoid a memory leak.
  (0, _react.useEffect)(() => {
    mounted.current = true;
    return () => {
      mounted.current = false;
    };
  }, []);
  const handleExecutePolicy = () => {
    setIsExecuting(true);
    (0, _api.executeEnrichPolicy)(policyToExecute).then(({
      data,
      error
    }) => {
      if (data) {
        const successMessage = _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.executeModal.successExecuteNotificationMessage', {
          defaultMessage: 'Executed {policyToExecute}',
          values: {
            policyToExecute
          }
        });
        notificationService.showSuccessToast(successMessage);
        return callback({
          hasExecutedPolicy: true
        });
      }
      if (error) {
        const errorMessage = _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.executeModal.errorExecuteNotificationMessage', {
          defaultMessage: "Error executing enrich policy: ''{error}''",
          values: {
            error: error.message
          }
        });
        notificationService.showDangerToast(errorMessage);
      }
      callback();
    }).finally(() => {
      if (mounted.current) {
        setIsExecuting(false);
      }
    });
  };
  const handleOnCancel = () => {
    callback();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "executePolicyModal",
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.executeModal.confirmTitle', {
      defaultMessage: 'Execute enrich policy'
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: handleOnCancel,
    onConfirm: handleExecutePolicy,
    cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.executeModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.executeModal.executeButton', {
      defaultMessage: 'Execute'
    }),
    confirmButtonDisabled: isExecuting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicies.executeModal.bodyCopy",
    defaultMessage: "You are about to execute the enrich policy {policy}.",
    values: {
      policy: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 21
        }
      }, policyToExecute)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })));
};
exports.ExecutePolicyModal = ExecutePolicyModal;