"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectInferenceId = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _inferenceCommon = require("@kbn/inference-common");
var _react = _interopRequireWildcard(require("react"));
var _lib = require("../../../lib");
var _app_context = require("../../../../../app_context");
var _api = require("../../../../../services/api");
var _shared_imports = require("../../../shared_imports");
var _ml_vcu_usage_cost_tour = require("./ml_vcu_usage_cost_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/select_inference_id.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceFlyoutWrapper = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/inference-endpoint-ui-common'))));
// Task types that are compatible with semantic_text field type
const COMPATIBLE_TASK_TYPES = ['text_embedding', 'sparse_embedding'];
/**
 * Type guard to check if a task type is compatible with semantic_text fields
 */
const isCompatibleTaskType = taskType => {
  return COMPATIBLE_TASK_TYPES.includes(taskType);
};
const SelectInferenceId = ({
  'data-test-subj': dataTestSubj
}) => {
  const config = (0, _lib.getFieldConfig)('inference_id');
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "inference_id",
    fieldConfig: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, field => {
    return /*#__PURE__*/_react.default.createElement(SelectInferenceIdContent, {
      "data-test-subj": dataTestSubj,
      value: field.value,
      setValue: field.setValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    });
  });
};
exports.SelectInferenceId = SelectInferenceId;
const SelectInferenceIdContent = ({
  'data-test-subj': dataTestSubj,
  setValue,
  value
}) => {
  var _share$url$locators$g, _options$find;
  const {
    core: {
      application,
      http
    },
    config: {
      enforceAdaptiveAllocations
    },
    services: {
      notificationService: {
        toasts
      }
    },
    docLinks,
    plugins: {
      cloud,
      share
    }
  } = (0, _app_context.useAppContext)();
  const {
    isLoading,
    data: endpoints,
    resendRequest
  } = (0, _api.useLoadInferenceEndpoints)();
  const [isInferenceFlyoutVisible, setIsInferenceFlyoutVisible] = (0, _react.useState)(false);
  const [isInferencePopoverVisible, setIsInferencePopoverVisible] = (0, _react.useState)(false);
  const config = (0, _lib.getFieldConfig)('inference_id');
  const inferenceEndpointsPageLink = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('SEARCH_INFERENCE_ENDPOINTS')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const onFlyoutClose = (0, _react.useCallback)(() => {
    setIsInferenceFlyoutVisible(false);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsInferencePopoverVisible(false);
  }, []);
  const onSubmitSuccess = (0, _react.useCallback)(newEndpointId => {
    resendRequest();
    setValue(newEndpointId);
  }, [resendRequest, setValue]);

  /**
   * Determines the default inference endpoint ID to select.
   * Prioritizes .elser-2-elastic (ELSER in EIS), falls back to the first available compatible endpoint.
   * Only considers endpoints compatible with semantic_text field type.
   */
  const getDefaultInferenceId = (0, _react.useCallback)(endpointsList => {
    var _elserInEis$inference;
    if (!(endpointsList !== null && endpointsList !== void 0 && endpointsList.length)) {
      return undefined;
    }

    // Filter to only compatible endpoints first
    const compatibleEndpoints = endpointsList.filter(endpoint => isCompatibleTaskType(endpoint.task_type));
    if (!compatibleEndpoints.length) {
      return undefined;
    }
    const elserInEis = compatibleEndpoints.find(endpoint => endpoint.inference_id === _inferenceCommon.defaultInferenceEndpoints.ELSER_IN_EIS_INFERENCE_ID);
    return (_elserInEis$inference = elserInEis === null || elserInEis === void 0 ? void 0 : elserInEis.inference_id) !== null && _elserInEis$inference !== void 0 ? _elserInEis$inference : compatibleEndpoints[0].inference_id;
  }, []);

  /**
   * Computes the selectable options for the inference endpoint dropdown.
   * Only includes endpoints compatible with semantic_text (text_embedding and sparse_embedding).
   * Includes optimistic updates for newly created endpoints that may not be in the list yet.
   */
  const options = (0, _react.useMemo)(() => {
    var _endpoints$filter;
    // Filter to only text and sparse embedding endpoints (compatible with semantic_text)
    const compatibleEndpoints = (_endpoints$filter = endpoints === null || endpoints === void 0 ? void 0 : endpoints.filter(endpoint => isCompatibleTaskType(endpoint.task_type))) !== null && _endpoints$filter !== void 0 ? _endpoints$filter : [];
    const selectableOptions = compatibleEndpoints.map(endpoint => ({
      label: endpoint.inference_id,
      'data-test-subj': `custom-inference_${endpoint.inference_id}`,
      checked: value === endpoint.inference_id ? 'on' : undefined
    }));

    // Optimistic update: if a value is set but not in the list, add it
    // (handles race condition where backend hasn't updated yet after creating a new endpoint)
    const isValueInOptions = selectableOptions.some(option => option.label === value);
    if (value && !isValueInOptions) {
      selectableOptions.push({
        label: value,
        checked: 'on',
        'data-test-subj': `custom-inference_${value}`
      });
    }
    return selectableOptions;
  }, [endpoints, value]);
  const selectedOptionLabel = (_options$find = options.find(option => option.checked)) === null || _options$find === void 0 ? void 0 : _options$find.label;
  const inferencePopover = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 15
      }
    }, config.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      color: "text",
      "data-test-subj": "inferenceIdButton",
      onClick: () => {
        setIsInferencePopoverVisible(prev => !prev);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, selectedOptionLabel || _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.alreadyExistsLabel', {
      defaultMessage: 'No inference endpoint selected'
    }))),
    isOpen: isInferencePopoverVisible,
    panelPaddingSize: "none",
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "createInferenceEndpointButton",
    icon: "plusInCircle",
    size: "s",
    "data-test-subj": "createInferenceEndpointButton",
    onClick: e => {
      e.preventDefault();
      setIsInferenceFlyoutVisible(true);
      setIsInferencePopoverVisible(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.createInferenceEndpointButton', {
    defaultMessage: 'Add inference endpoint'
  })), inferenceEndpointsPageLink && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "manageInferenceEndpointButton",
    icon: "gear",
    size: "s",
    "data-test-subj": "manageInferenceEndpointButton",
    href: inferenceEndpointsPageLink,
    onClick: e => {
      e.preventDefault();
      application.navigateToUrl(inferenceEndpointsPageLink);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.manageInferenceEndpointButton', {
    defaultMessage: 'Manage Inference Endpoints'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.Label', {
      defaultMessage: 'Existing endpoints'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.ariaLabel', {
      defaultMessage: 'Existing endpoints'
    }),
    "data-test-subj": dataTestSubj,
    searchable: true,
    isLoading: isLoading,
    singleSelection: "always",
    defaultChecked: true,
    searchProps: {
      compressed: true,
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.placeholder', {
        defaultMessage: 'Search'
      })
    },
    options: options,
    onChange: newOptions => {
      var _newOptions$find;
      setValue(((_newOptions$find = newOptions.find(option => option.checked)) === null || _newOptions$find === void 0 ? void 0 : _newOptions$find.label) || '');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 19
    }
  }), list))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 33
      }
    }),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.inferenceManagement.inferenceAPIDocumentation,
    target: "_blank",
    "data-test-subj": "learn-how-to-create-inference-endpoints",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.learnHowToCreateInferenceEndpoints', {
    defaultMessage: 'Learn how to create inference endpoints'
  }))));

  /**
   * Auto-select default inference endpoint when:
   * - No endpoint is currently selected (!value)
   * - Endpoints have been loaded (endpoints?.length)
   * This ensures a good default UX without requiring manual selection.
   */
  (0, _react.useEffect)(() => {
    const shouldSetDefault = !value && (endpoints === null || endpoints === void 0 ? void 0 : endpoints.length);
    if (!shouldSetDefault) {
      return;
    }
    const defaultId = getDefaultInferenceId(endpoints);
    if (defaultId) {
      setValue(defaultId);
    }
  }, [endpoints, value, setValue, getDefaultInferenceId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "selectInferenceId",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 9
    }
  }, cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled ? /*#__PURE__*/_react.default.createElement(_ml_vcu_usage_cost_tour.MlVcuUsageCostTour, {
    children: inferencePopover(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 13
    }
  }) : inferencePopover(), isInferenceFlyoutVisible && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 33
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(InferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    http: http,
    toasts: toasts,
    isEdit: false,
    onSubmitSuccess: onSubmitSuccess,
    enforceAdaptiveAllocations: enforceAdaptiveAllocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.noReferenceModelStartWarningMessage', {
    defaultMessage: 'The referenced model for this inference endpoint will be started when adding this field.'
  })))))));
};