"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePhaseColors = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePhaseColors = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    hot: euiTheme.colors.vis.euiColorVis6,
    warm: euiTheme.colors.vis.euiColorVis9,
    cold: euiTheme.colors.vis.euiColorVis2,
    frozen: euiTheme.colors.vis.euiColorVis4,
    delete: euiTheme.colors.borderBaseSubdued
  };
};
exports.usePhaseColors = usePhaseColors;