"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.imageEmbeddableSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _presentationPublishingSchemas = require("@kbn/presentation-publishing-schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const imageFileSrcSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal('file'),
  fileId: _configSchema.schema.string(),
  fileImageMeta: _configSchema.schema.maybe(_configSchema.schema.object({
    blurHash: _configSchema.schema.maybe(_configSchema.schema.string()),
    width: _configSchema.schema.number({
      meta: {
        description: 'Width of the image in pixels'
      }
    }),
    height: _configSchema.schema.number({
      meta: {
        description: 'Height of the image in pixels'
      }
    })
  }))
});
const imageUrlSrcSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal('url'),
  url: _configSchema.schema.string({
    meta: {
      description: 'URL of the image'
    }
  })
});
const imageConfigSchema = _configSchema.schema.object({
  src: _configSchema.schema.oneOf([imageFileSrcSchema, imageUrlSrcSchema], {
    meta: {
      description: 'Image source (file or URL)'
    }
  }),
  altText: _configSchema.schema.maybe(_configSchema.schema.string()),
  sizing: _configSchema.schema.object({
    objectFit: _configSchema.schema.oneOf([_configSchema.schema.literal('fill'), _configSchema.schema.literal('contain'), _configSchema.schema.literal('cover'), _configSchema.schema.literal('none')], {
      meta: {
        description: 'How the image should be sized within its container'
      }
    })
  }),
  backgroundColor: _configSchema.schema.maybe(_configSchema.schema.string())
});
const imageEmbeddableSchema = exports.imageEmbeddableSchema = _configSchema.schema.allOf([_configSchema.schema.object({
  imageConfig: imageConfigSchema,
  enhancements: _configSchema.schema.maybe(_configSchema.schema.any())
}), _presentationPublishingSchemas.serializedTitlesSchema], {
  meta: {
    description: 'Image embeddable schema'
  }
});