"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransforms = getTransforms;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getTransforms(transformEnhancementsIn, transformEnhancementsOut) {
  return {
    transformOutInjectsReferences: true,
    transformIn: state => {
      const {
        enhancementsState,
        enhancementsReferences
      } = state.enhancements ? transformEnhancementsIn(state.enhancements) : {
        enhancementsState: undefined,
        enhancementsReferences: []
      };
      return {
        state: {
          ...state,
          ...(enhancementsState ? {
            enhancements: enhancementsState
          } : {})
        },
        references: enhancementsReferences
      };
    },
    transformOut: (state, references) => {
      const enhancementsState = state.enhancements ? transformEnhancementsOut(state.enhancements, references !== null && references !== void 0 ? references : []) : undefined;
      return {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {})
      };
    }
  };
}