"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PENDING_MIGRATION_TIMEOUT = void 0;
exports.isSpaceAwarenessEnabled = isSpaceAwarenessEnabled;
exports.isSpaceAwarenessMigrationPending = isSpaceAwarenessMigrationPending;
var _app_context = require("../app_context");
var _cache = require("../epm/packages/cache");
var _settings = require("../settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PENDING_MIGRATION_TIMEOUT = exports.PENDING_MIGRATION_TIMEOUT = 60 * 60 * 1000;
/**
 * Return true if user optin for the space awareness feature.
 */
async function isSpaceAwarenessEnabled() {
  var _ref;
  if (!_app_context.appContextService.getExperimentalFeatures().useSpaceAwareness) {
    return false;
  }
  const cache = (0, _cache.getIsSpaceAwarenessEnabledCache)();
  if (typeof cache === 'boolean') {
    return cache;
  }
  const settings = await (0, _settings.getSettingsOrUndefined)(_app_context.appContextService.getInternalUserSOClient());

  // @ts-expect-error upgrade typescript v5.9.3
  const res = (_ref = (settings === null || settings === void 0 ? void 0 : settings.use_space_awareness_migration_status) === 'success') !== null && _ref !== void 0 ? _ref : false;
  (0, _cache.setIsSpaceAwarenessEnabledCache)(res);
  return res;
}

/**
 * Return true if space awareness migration is currently running
 */
async function isSpaceAwarenessMigrationPending() {
  if (!_app_context.appContextService.getExperimentalFeatures().useSpaceAwareness) {
    return false;
  }
  const settings = await (0, _settings.getSettingsOrUndefined)(_app_context.appContextService.getInternalUserSOClient());
  if ((settings === null || settings === void 0 ? void 0 : settings.use_space_awareness_migration_status) === 'pending' && settings !== null && settings !== void 0 && settings.use_space_awareness_migration_started_at && new Date(settings === null || settings === void 0 ? void 0 : settings.use_space_awareness_migration_started_at).getTime() > Date.now() - PENDING_MIGRATION_TIMEOUT) {
    return true;
  }
  return false;
}