"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appContextService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _repoInfo = require("@kbn/repo-info");
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
var _common = require("@kbn/spaces-plugin/common");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _experimental_features = require("../../common/experimental_features");
var _types = require("../types");
var _constants = require("../constants");
var _constants2 = require("@kbn/spaces-plugin/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppContextService {
  constructor() {
    (0, _defineProperty2.default)(this, "encryptedSavedObjects", void 0);
    (0, _defineProperty2.default)(this, "encryptedSavedObjectsSetup", void 0);
    (0, _defineProperty2.default)(this, "encryptedSavedObjectsStart", void 0);
    (0, _defineProperty2.default)(this, "data", void 0);
    (0, _defineProperty2.default)(this, "esClient", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", _experimental_features.allowedExperimentalValues);
    (0, _defineProperty2.default)(this, "securityCoreStart", void 0);
    (0, _defineProperty2.default)(this, "securitySetup", void 0);
    (0, _defineProperty2.default)(this, "securityStart", void 0);
    (0, _defineProperty2.default)(this, "config$", void 0);
    (0, _defineProperty2.default)(this, "configSubject$", void 0);
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "isProductionMode", false);
    (0, _defineProperty2.default)(this, "kibanaVersion", _repoInfo.kibanaPackageJson.version);
    (0, _defineProperty2.default)(this, "kibanaBranch", _repoInfo.kibanaPackageJson.branch);
    (0, _defineProperty2.default)(this, "kibanaInstanceId", '');
    (0, _defineProperty2.default)(this, "cloud", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "httpSetup", void 0);
    (0, _defineProperty2.default)(this, "externalCallbacks", new Map());
    (0, _defineProperty2.default)(this, "telemetryEventsSender", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsTagging", void 0);
    (0, _defineProperty2.default)(this, "bulkActionsResolver", void 0);
    (0, _defineProperty2.default)(this, "messageSigningService", void 0);
    (0, _defineProperty2.default)(this, "uninstallTokenService", void 0);
    (0, _defineProperty2.default)(this, "taskManagerStart", void 0);
    (0, _defineProperty2.default)(this, "fetchUsage", void 0);
    (0, _defineProperty2.default)(this, "lockManagerService", void 0);
    (0, _defineProperty2.default)(this, "alertingStart", void 0);
  }
  start(appContext) {
    var _appContext$encrypted;
    this.data = appContext.data;
    this.esClient = appContext.elasticsearch.client.asInternalUser;
    this.encryptedSavedObjectsStart = appContext.encryptedSavedObjectsStart;
    this.encryptedSavedObjects = (_appContext$encrypted = appContext.encryptedSavedObjectsStart) === null || _appContext$encrypted === void 0 ? void 0 : _appContext$encrypted.getClient();
    this.encryptedSavedObjectsSetup = appContext.encryptedSavedObjectsSetup;
    this.securityCoreStart = appContext.securityCoreStart;
    this.securitySetup = appContext.securitySetup;
    this.securityStart = appContext.securityStart;
    this.savedObjects = appContext.savedObjects;
    this.experimentalFeatures = appContext.experimentalFeatures;
    this.isProductionMode = appContext.isProductionMode;
    this.cloud = appContext.cloud;
    this.logger = appContext.logger;
    this.kibanaVersion = appContext.kibanaVersion;
    this.kibanaBranch = appContext.kibanaBranch;
    this.kibanaInstanceId = appContext.kibanaInstanceId;
    this.httpSetup = appContext.httpSetup;
    this.telemetryEventsSender = appContext.telemetryEventsSender;
    this.savedObjectsTagging = appContext.savedObjectsTagging;
    this.bulkActionsResolver = appContext.bulkActionsResolver;
    this.messageSigningService = appContext.messageSigningService;
    this.uninstallTokenService = appContext.uninstallTokenService;
    this.taskManagerStart = appContext.taskManagerStart;
    this.fetchUsage = appContext.fetchUsage;
    this.lockManagerService = appContext.lockManagerService;
    this.alertingStart = appContext.alertingStart;
    if (appContext.config$) {
      this.config$ = appContext.config$;
      const initialValue = appContext.configInitialValue;
      this.configSubject$ = new _rxjs.BehaviorSubject(initialValue);
      this.config$.subscribe(this.configSubject$);
    }
  }
  stop() {
    this.externalCallbacks.clear();
  }
  getData() {
    if (!this.data) {
      throw new Error('Data start service not set.');
    }
    return this.data;
  }
  getEncryptedSavedObjects() {
    if (!this.encryptedSavedObjects) {
      throw new Error('Encrypted saved object start service not set.');
    }
    return this.encryptedSavedObjects;
  }
  getSecurityCore() {
    return this.securityCoreStart;
  }
  getSecurity() {
    return this.securityStart;
  }
  getSecuritySetup() {
    return this.securitySetup;
  }
  getSecurityLicense() {
    return this.securitySetup.license;
  }
  getCloud() {
    return this.cloud;
  }
  getLogger() {
    if (!this.logger) {
      throw new Error('Logger not set.');
    }
    return this.logger;
  }
  getConfig() {
    var _this$configSubject$;
    return (_this$configSubject$ = this.configSubject$) === null || _this$configSubject$ === void 0 ? void 0 : _this$configSubject$.value;
  }
  getConfig$() {
    return this.config$;
  }
  getExperimentalFeatures() {
    return this.experimentalFeatures;
  }
  getSavedObjects() {
    if (!this.savedObjects) {
      throw new Error('Saved objects start service not set.');
    }
    return this.savedObjects;
  }
  getSavedObjectsTagging() {
    if (!this.savedObjectsTagging) {
      throw new Error('Saved object tagging start service not set.');
    }
    return this.savedObjectsTagging;
  }
  getInternalUserSOClientForSpaceId(spaceId) {
    const request = (0, _coreHttpServerUtils.kibanaRequestFactory)({
      headers: {},
      path: '/',
      route: {
        settings: {}
      },
      url: {
        href: '',
        hash: ''
      },
      raw: {
        req: {
          url: '/'
        }
      }
    });
    if (this.httpSetup && spaceId && spaceId !== _common.DEFAULT_SPACE_ID && spaceId !== _constants2.ALL_SPACES_ID) {
      var _this$httpSetup;
      (_this$httpSetup = this.httpSetup) === null || _this$httpSetup === void 0 ? void 0 : _this$httpSetup.basePath.set(request, `/s/${spaceId}`);
    }

    // soClient as kibana internal users, be careful on how you use it, security is not enabled
    return appContextService.getSavedObjects().getScopedClient(request, {
      includedHiddenTypes: [_constants.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE, _types.KibanaSavedObjectType.alertingRuleTemplate],
      excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID]
    });
  }
  getInternalUserSOClient(request) {
    if (!request) {
      request = {
        headers: {},
        getBasePath: () => '',
        path: '/',
        route: {
          settings: {}
        },
        url: {
          href: {}
        },
        raw: {
          req: {
            url: '/'
          }
        },
        isFakeRequest: true
      };
    }

    // soClient as kibana internal users, be careful on how you use it, security is not enabled
    return appContextService.getSavedObjects().getScopedClient(request, {
      includedHiddenTypes: [_constants.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE, _types.KibanaSavedObjectType.alertingRuleTemplate],
      excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID]
    });
  }
  getInternalUserSOClientWithoutSpaceExtension() {
    const fakeRequest = {
      headers: {},
      getBasePath: () => '',
      path: '/',
      route: {
        settings: {}
      },
      url: {
        href: {}
      },
      raw: {
        req: {
          url: '/'
        }
      },
      isFakeRequest: true
    };

    // soClient as kibana internal users, be careful on how you use it, security is not enabled
    return appContextService.getSavedObjects().getScopedClient(fakeRequest, {
      excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID, _coreSavedObjectsServer.SPACES_EXTENSION_ID],
      includedHiddenTypes: [_constants.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE, _types.KibanaSavedObjectType.alertingRuleTemplate]
    });
  }
  getInternalUserESClient() {
    if (!this.esClient) {
      throw new Error('Elasticsearch start service not set.');
    }
    // soClient as kibana internal users, be careful on how you use it, security is not enabled
    return this.esClient;
  }
  getIsProductionMode() {
    return this.isProductionMode;
  }
  getHttpSetup() {
    if (!this.httpSetup) {
      throw new Error('HttpServiceSetup not set.');
    }
    return this.httpSetup;
  }
  getEncryptedSavedObjectsSetup() {
    return this.encryptedSavedObjectsSetup;
  }
  getEncryptedSavedObjectsStart() {
    return this.encryptedSavedObjectsStart;
  }
  getKibanaVersion() {
    return this.kibanaVersion;
  }
  getKibanaBranch() {
    return this.kibanaBranch;
  }
  getKibanaInstanceId() {
    return this.kibanaInstanceId;
  }
  getTaskManagerStart() {
    return this.taskManagerStart;
  }
  addExternalCallback(type, callback) {
    if (!this.externalCallbacks.has(type)) {
      this.externalCallbacks.set(type, new Set());
    }
    this.externalCallbacks.get(type).add(callback);
  }
  getExternalCallbacks(type) {
    if (this.externalCallbacks) {
      return this.externalCallbacks.get(type);
    }
  }
  getTelemetryEventsSender() {
    return this.telemetryEventsSender;
  }
  getBulkActionsResolver() {
    return this.bulkActionsResolver;
  }
  getMessageSigningService() {
    return this.messageSigningService;
  }
  getUninstallTokenService() {
    return this.uninstallTokenService;
  }
  getFetchUsage() {
    return this.fetchUsage;
  }
  getLockManagerService() {
    return this.lockManagerService;
  }
  getAlertingStart() {
    return this.alertingStart;
  }
}
const appContextService = exports.appContextService = new AppContextService();