"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncAgentlessPoliciesHandler = exports.deleteAgentlessPolicyHandler = exports.createAgentlessPolicyHandler = void 0;
var _constants = require("../../../common/constants");
var _simplified_package_policy_helper = require("../../../common/services/simplified_package_policy_helper");
var _services = require("../../services");
var _agentless_policies = require("../../services/agentless/agentless_policies");
var _deployment_sync = require("../../services/agentless/deployment_sync");
var _agentless_agent = require("../../services/agents/agentless_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syncAgentlessPoliciesHandler = async (context, request, response) => {
  var _request$body;
  const logger = _services.appContextService.getLogger().get('agentless');
  await (0, _deployment_sync.syncAgentlessDeployments)({
    logger,
    agentlessAgentService: _agentless_agent.agentlessAgentService
  }, {
    dryRun: (_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.dryRun
  });
  return response.ok({
    body: {
      success: true
    }
  });
};
exports.syncAgentlessPoliciesHandler = syncAgentlessPoliciesHandler;
const createAgentlessPolicyHandler = async (context, request, response) => {
  const [coreContext, fleetContext] = await Promise.all([context.core, context.fleet]);
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const logger = _services.appContextService.getLogger().get('agentless');
  const agentlessPoliciesService = new _agentless_policies.AgentlessPoliciesServiceImpl(fleetContext.packagePolicyService.asCurrentUser, soClient, esClient, logger);
  const packagePolicy = await agentlessPoliciesService.createAgentlessPolicy(request.body, context, request);
  return response.ok({
    body: {
      item: request.query.format === _constants.inputsFormat.Simplified ? (0, _simplified_package_policy_helper.packagePolicyToSimplifiedPackagePolicy)(packagePolicy) : packagePolicy
    }
  });
};
exports.createAgentlessPolicyHandler = createAgentlessPolicyHandler;
const deleteAgentlessPolicyHandler = async (context, request, response) => {
  const [coreContext, fleetContext] = await Promise.all([context.core, context.fleet]);
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const logger = _services.appContextService.getLogger().get('agentless');
  const agentlessPoliciesService = new _agentless_policies.AgentlessPoliciesServiceImpl(fleetContext.packagePolicyService.asCurrentUser, soClient, esClient, logger);
  await agentlessPoliciesService.deleteAgentlessPolicy(request.params.policyId, {
    force: request.query.force
  }, context, request);
  return response.ok({
    body: {
      id: request.params.policyId
    }
  });
};
exports.deleteAgentlessPolicyHandler = deleteAgentlessPolicyHandler;