"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendDeleteAgentlessPolicy = exports.sendCreateAgentlessPolicy = void 0;
var _common = require("../../../common");
var _services = require("../../../common/services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendCreateAgentlessPolicy = (body, query) => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentlessPolicyRouteService.getCreatePath(),
    method: 'post',
    version: _common.API_VERSIONS.public.v1,
    body: JSON.stringify(body),
    query
  });
};
exports.sendCreateAgentlessPolicy = sendCreateAgentlessPolicy;
const sendDeleteAgentlessPolicy = (policyId, query) => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentlessPolicyRouteService.getDeletePath(policyId),
    method: 'delete',
    version: _common.API_VERSIONS.public.v1,
    query
  });
};
exports.sendDeleteAgentlessPolicy = sendDeleteAgentlessPolicy;