"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatformSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _epm = require("../../common/constants/epm");
var _hooks = require("../hooks");
var _kubernetes_instructions = require("./agent_enrollment_flyout/kubernetes_instructions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/platform_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PlatformSelector = ({
  installCommand,
  hasK8sIntegration,
  cloudSecurityIntegration,
  hasK8sIntegrationMultiPage,
  isManaged,
  enrollToken,
  hasFleetServer,
  fleetServerHost,
  fullCopyButton,
  onCopy
}) => {
  const {
    platform,
    setPlatform
  } = (0, _hooks.usePlatform)();
  const [showExtendedPlatforms, setShowExtendedPlatforms] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (hasK8sIntegration || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE && isManaged) {
      setPlatform('kubernetes');
    }
  }, [hasK8sIntegration, cloudSecurityIntegration, isManaged, setPlatform]);

  // Show K8 as a platform option if policy has K8s integration or is managed
  const showK8 = !hasFleetServer && (isManaged || hasK8sIntegration);
  const extendedPlatformOptions = [...(showK8 ? [_hooks.KUBERNETES_PLATFORM_OPTION] : []), ..._hooks.EXTENDED_PLATFORM_OPTIONS];
  const extendedPlatforms = extendedPlatformOptions.map(option => option.id);
  const [copyButtonClicked, setCopyButtonClicked] = (0, _react.useState)(false);
  const systemPackageCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.callout', {
      defaultMessage: 'We recommend using the installers (TAR/ZIP) over system packages (RPM/DEB) because they provide the ability to upgrade your agent with Fleet.'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  });
  const k8sCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.k8sCallout', {
      defaultMessage: 'We recommend adding the Kubernetes integration to your agent policy in order to get useful metrics and logs from your Kubernetes clusters.'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  });
  const k8sCSPMCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.placeHolderCallout', {
      defaultMessage: 'We strongly advise against deploying CSPM within a Kubernetes cluster. Doing so may lead to redundant data fetching, which can cause increased consumption costs within your Elastic account and potentially trigger API rate limiting in your cloud account(s).'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  });
  const macCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.macCallout', {
      defaultMessage: 'We recommend against deploying this integration within Mac as it is currently not being supported.'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  });
  const onTextAreaClick = () => {
    if (onCopy) onCopy();
  };
  const onCopyButtonClick = copy => {
    copy();
    setCopyButtonClicked(true);
    if (onCopy) onCopy();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hasK8sIntegrationMultiPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.agentEnrollment.visiblePlatformSelectorLabel', {
      defaultMessage: 'Platform options'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, _hooks.VISIBLE_PLATFORM_OPTIONS.map(option => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    key: option.id,
    isToggle: true,
    isSelected: platform === option.id,
    hasActiveFilters: platform === option.id,
    onClick: () => setPlatform(option.id),
    "data-test-subj": option['data-test-subj'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      "data-test-subj": "platformSelectorExtended",
      onClick: () => setShowExtendedPlatforms(!showExtendedPlatforms),
      isSelected: showExtendedPlatforms,
      hasActiveFilters: extendedPlatforms.includes(platform),
      numActiveFilters: extendedPlatforms.includes(platform) ? 1 : 0,
      css: (0, _react2.css)`
                    .euiFilterButton__text {
                      min-inline-size: 0;
                    }
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 17
      }
    }, "\u2026"),
    isOpen: showExtendedPlatforms,
    closePopover: () => setShowExtendedPlatforms(false),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.agentEnrollment.extendedPlatformSelectorLabel', {
      defaultMessage: 'Additional platform options'
    }),
    singleSelection: true,
    options: extendedPlatformOptions.map(option => ({
      key: option.id,
      label: option.label,
      checked: platform === option.id ? 'on' : undefined,
      'data-test-subj': option['data-test-subj']
    })),
    onChange: (_allOptions, _event, option) => setPlatform(option.key),
    css: {
      width: 150
    },
    listProps: {
      paddingSize: 'none',
      onFocusBadge: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, list => list))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }), ['deb_aarch64', 'deb_x86_64', 'rpm_aarch64', 'rpm_x86_64'].includes(platform) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, systemPackageCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  })), ['mac_aarch64', 'mac_x86_64'].includes(platform) && ((cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, macCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 15
    }
  })), platform === 'kubernetes' && (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCSPMCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  })), platform === 'kubernetes' && !hasK8sIntegration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  })), platform === 'kubernetes' && isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_kubernetes_instructions.KubernetesInstructions, {
    onCopy: onCopy,
    onDownload: onCopy,
    enrollmentAPIKey: enrollToken,
    fleetServerHost: fleetServerHost,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  })), !hasK8sIntegrationMultiPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, platform === 'kubernetes' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.kubernetesCommandInstructions",
    defaultMessage: "From the directory where the manifest is downloaded, run the apply command.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": "enrollmentInstructionsCodeBlock",
    onClick: onTextAreaClick,
    fontSize: "m",
    isCopyable: !fullCopyButton,
    paddingSize: "m",
    css: (0, _react2.css)`
                max-width: 1100px;
              `,
    whiteSpace: "pre",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 13
    }
  }, installCommand[platform]), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 13
    }
  }), fullCopyButton && /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: installCommand[platform],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 15
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "copyClipboard",
    size: "m",
    onClick: () => onCopyButtonClick(copy),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 19
    }
  }, copyButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButtonClicked",
    defaultMessage: "Copied",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 23
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButton",
    defaultMessage: "Copy to clipboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 23
    }
  }))))));
};
exports.PlatformSelector = PlatformSelector;