"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackLink = BackLink;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/components/back_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function BackLink({
  queryParams,
  integrationsPath
}) {
  const {
    application: {
      navigateToApp
    }
  } = (0, _hooks.useStartServices)();
  const {
    returnAppId,
    returnPath
  } = (0, _react.useMemo)(() => {
    return {
      // Check for custom path params to redirect back to a specified app's path
      returnAppId: queryParams.get('returnAppId'),
      returnPath: queryParams.get('returnPath')
    };
  }, [queryParams]);
  const appId = returnAppId && returnPath ? returnAppId : 'integrations';
  const path = returnAppId && returnPath ? returnPath : integrationsPath;

  // Maintain 'Back to integrations' for the AI4SOC integrations page
  const message = !returnPath || returnPath.includes('/configurations/integrations') ? BACK_TO_INTEGRATIONS : BACK_TO_SELECTION;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    size: "xs",
    flush: "left",
    onClick: () => {
      navigateToApp(appId, {
        path
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, message));
}
const BACK_TO_INTEGRATIONS = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epm.browseAllButtonText",
  defaultMessage: "Back to integrations",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 3
  }
});
const BACK_TO_SELECTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epm.returnToObservabilityOnboarding",
  defaultMessage: "Back to selection",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 3
  }
});