"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfirmOpenUnverified = void 0;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireWildcard(require("react"));
var _use_core = require("../../../hooks/use_core");
var _confirm_open_unverified_modal = require("../components/confirm_open_unverified_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/hooks/use_confirm_open_unverified.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Direct imports are important here, importing all hooks breaks unit tests
// and increases bundle size because this is imported on first page load
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const confirmOpenUnverified = ({
  pkgName,
  fleetServices
}) => new Promise(resolve => {
  const {
    overlays,
    docLinks,
    ...startServices
  } = fleetServices;
  const session = overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_confirm_open_unverified_modal.ConfirmOpenUnverifiedModal, {
    pkgName: pkgName,
    onConfirm: () => {
      session.close();
      resolve(true);
    },
    onCancel: () => {
      session.close();
      resolve(false);
    },
    docLinks: docLinks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }), startServices));
});
const useConfirmOpenUnverified = () => {
  const fleetServices = (0, _use_core.useStartServices)();
  return (0, _react.useCallback)(pkgName => confirmOpenUnverified({
    pkgName,
    fleetServices
  }), [fleetServices]);
};
exports.useConfirmOpenUnverified = useConfirmOpenUnverified;