"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeStatusCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../hooks");
var _constants = require("../../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/edit_package_policy_page/components/upgrade.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    padding: 0;
  }
`;
const HasNewSecretsCallOut = ({
  newSecrets
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.hasNewSecretsTitle', {
      defaultMessage: 'New secrets added'
    }),
    color: "primary",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.hasNewSecrets",
    defaultMessage: "Some of this integration's form fields have been converted to secrets in this version. Your existing values are autofilled in each secret input during this upgrade, but you won't be able to view them again after saving. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.policySecrets,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 13
        }
      }, "Learn more.")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.hasNewSecretsList",
    defaultMessage: "New secrets: {secrets}",
    values: {
      secrets: /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 13
        }
      }, newSecrets.map(secret => /*#__PURE__*/_react.default.createElement("li", {
        key: secret.title,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 17
        }
      }, secret.title)))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
const HasConflictsCallout = ({
  currentPackagePolicy,
  proposedUpgradePackagePolicy,
  onPreviousConfigurationClick
}) => {
  var _currentPackagePolicy, _proposedUpgradePacka;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.errorTitle', {
      defaultMessage: 'Review field conflicts'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.errorContent",
    defaultMessage: "This integration has conflicting fields from version {currentVersion} to {upgradeVersion} Review the configuration and save to perform the upgrade. You may reference your {previousConfigurationLink} for comparison.",
    values: {
      currentVersion: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : (_currentPackagePolicy = currentPackagePolicy.package) === null || _currentPackagePolicy === void 0 ? void 0 : _currentPackagePolicy.version,
      upgradeVersion: proposedUpgradePackagePolicy === null || proposedUpgradePackagePolicy === void 0 ? void 0 : (_proposedUpgradePacka = proposedUpgradePackagePolicy.package) === null || _proposedUpgradePacka === void 0 ? void 0 : _proposedUpgradePacka.version,
      previousConfigurationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onPreviousConfigurationClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradePackagePolicy.statusCallout.previousConfigurationLink",
        defaultMessage: "previous configuration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }));
};
const ReadyToUpgradeCallOut = ({
  currentPackagePolicy,
  proposedUpgradePackagePolicy
}) => {
  var _currentPackagePolicy2, _proposedUpgradePacka2;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.successTitle', {
      defaultMessage: 'Ready to upgrade'
    }),
    color: "success",
    iconType: "checkInCircleFilled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.successContent",
    defaultMessage: "This integration is ready to be upgraded from version {currentVersion} to {upgradeVersion}. Review the changes below and save to upgrade.",
    values: {
      currentVersion: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : (_currentPackagePolicy2 = currentPackagePolicy.package) === null || _currentPackagePolicy2 === void 0 ? void 0 : _currentPackagePolicy2.version,
      upgradeVersion: proposedUpgradePackagePolicy === null || proposedUpgradePackagePolicy === void 0 ? void 0 : (_proposedUpgradePacka2 = proposedUpgradePackagePolicy.package) === null || _proposedUpgradePacka2 === void 0 ? void 0 : _proposedUpgradePacka2.version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }));
};
const UpgradeStatusCallout = ({
  dryRunData,
  newSecrets
}) => {
  var _dryRunData$0$agent_d;
  const [isPreviousVersionFlyoutOpen, setIsPreviousVersionFlyoutOpen] = (0, _react.useState)(false);
  if (!dryRunData) {
    return null;
  }
  const hasNewSecrets = newSecrets.length > 0;
  const [currentPackagePolicy, proposedUpgradePackagePolicy] = dryRunData[0].diff || [];
  const isReadyForUpgrade = currentPackagePolicy && !dryRunData[0].hasErrors;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPreviousVersionFlyoutOpen && currentPackagePolicy && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsPreviousVersionFlyoutOpen(false),
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "FleetPackagePolicyPreviousVersionFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.previousVersionFlyout.title",
    defaultMessage: "''{name}'' integration policy",
    values: {
      name: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : currentPackagePolicy.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(FlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    fontSize: "m",
    whiteSpace: "pre",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, JSON.stringify(((_dryRunData$0$agent_d = dryRunData[0].agent_diff) === null || _dryRunData$0$agent_d === void 0 ? void 0 : _dryRunData$0$agent_d[0]) || [], null, 2))))), isReadyForUpgrade ? /*#__PURE__*/_react.default.createElement(ReadyToUpgradeCallOut, {
    currentPackagePolicy: currentPackagePolicy,
    proposedUpgradePackagePolicy: proposedUpgradePackagePolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(HasConflictsCallout, {
    currentPackagePolicy: currentPackagePolicy,
    proposedUpgradePackagePolicy: proposedUpgradePackagePolicy,
    onPreviousConfigurationClick: () => setIsPreviousVersionFlyoutOpen(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }), hasNewSecrets && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(HasNewSecretsCallOut, {
    newSecrets: newSecrets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  })));
};
exports.UpgradeStatusCallout = UpgradeStatusCallout;