"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyEditorDatastreamPipelines = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _services = require("../../../../../../../common/services");
var _datastream_hooks = require("./datastream_hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/datastream_pipelines.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function toPipelineItem(pipelineName, canEdit = false) {
  return {
    pipelineName,
    canEdit
  };
}
function useDatastreamIngestPipelines(packageInfo, dataStream, pageUrl) {
  var _res$error;
  const [addPipelineUrl, setAddPipelineUrl] = (0, _react.useState)('');
  const {
    share
  } = (0, _hooks.useStartServices)();
  const ingestPipelineLocator = share.url.locators.get('INGEST_PIPELINES_APP_LOCATOR');
  const defaultPipelineName = (0, _services.getPipelineNameForDatastream)({
    dataStream,
    packageVersion: packageInfo.version
  });
  const customPipelineName = (0, _services.getCustomPipelineNameForDatastream)(dataStream);
  const res = (0, _hooks.useGetPipeline)(customPipelineName);
  const pipelines = (0, _react.useMemo)(() => {
    if (res.data) {
      return [toPipelineItem(defaultPipelineName), toPipelineItem(customPipelineName, true)];
    }
    return [toPipelineItem(defaultPipelineName)];
  }, [defaultPipelineName, customPipelineName, res.data]);
  (0, _react.useEffect)(() => {
    async function getUrl() {
      if (!ingestPipelineLocator) {
        return;
      }
      const createUrl = await ingestPipelineLocator.getUrl({
        page: 'pipeline_create'
      });
      setAddPipelineUrl(`${createUrl}?name=${customPipelineName}&redirect_path=${pageUrl}`);
    }
    getUrl();
  }, [customPipelineName, pageUrl, ingestPipelineLocator]);
  return {
    isLoading: res.isLoading,
    hasCustom: !res.isLoading && ((_res$error = res.error) === null || _res$error === void 0 ? void 0 : _res$error.statusCode) !== 404,
    pipelines,
    addPipelineUrl
  };
}
const PackagePolicyEditorDatastreamPipelines = ({
  packageInputStream,
  packageInfo,
  customDataset
}) => {
  const dataStream = customDataset ? {
    ...packageInputStream.data_stream,
    dataset: customDataset
  } : packageInputStream.data_stream;
  const {
    application,
    share,
    docLinks
  } = (0, _hooks.useStartServices)();
  const ingestPipelineLocator = share.url.locators.get('INGEST_PIPELINES_APP_LOCATOR');
  const pageUrl = (0, _datastream_hooks.usePackagePolicyEditorPageUrl)(packageInputStream.id);
  const {
    pipelines,
    addPipelineUrl,
    hasCustom,
    isLoading
  } = useDatastreamIngestPipelines(packageInfo, dataStream, pageUrl);
  if (!dataStream) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamIngestPipelinesTitle",
    defaultMessage: "Ingest pipelines",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamIngestPipelinesLabel",
    defaultMessage: "Ingest pipelines perform common transformations on the ingested data. We recommend modifying only the custom ingest pipeline. These pipelines are shared between integration policies of the same integration type. Hence, any modifications to the ingest pipelines would affect all the integration policies. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.datastreams,
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.packagePolicyEdotpr.datastreamIngestPipelines.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    items: pipelines,
    columns: [{
      field: 'pipelineName',
      name: ''
    }, {
      width: '60px',
      actions: [{
        icon: 'pencil',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.datastreamIngestPipelines.editBtn', {
          defaultMessage: 'Edit pipeline'
        }),
        'data-test-subj': 'datastreamEditPipelineBtn',
        name: 'edit',
        isPrimary: true,
        onClick: async el => {
          if (!ingestPipelineLocator) {
            return;
          }
          const url = await ingestPipelineLocator.getUrl({
            page: 'pipeline_edit',
            pipelineId: el.pipelineName
          });
          application.navigateToUrl(`${url}?redirect_path=${pageUrl}`);
        },
        available: ({
          canEdit
        }) => canEdit
      }, {
        icon: 'inspect',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.datastreamIngestPipelines.inspectBtn', {
          defaultMessage: 'Inspect pipeline'
        }),
        name: 'inspect',
        'data-test-subj': 'datastreamInspectPipelineBtn',
        isPrimary: true,
        onClick: async el => {
          if (!ingestPipelineLocator) {
            return;
          }
          const url = await ingestPipelineLocator.getUrl({
            page: 'pipeline_list'
          });
          application.navigateToUrl(`${url}?pipeline=${el.pipelineName}&redirect_path=${pageUrl}`);
        }
      }]
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  })), !isLoading && !hasCustom && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    iconType: "plusInCircle",
    "data-test-subj": "datastreamAddCustomIngestPipelineBtn",
    href: addPipelineUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamIngestPipelines.addCustomButn",
    defaultMessage: "Add custom pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }))));
};
exports.PackagePolicyEditorDatastreamPipelines = PackagePolicyEditorDatastreamPipelines;