"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSetDeploymentModeStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/steps/set_deployment_mode.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSetDeploymentModeStep = ({
  deploymentMode,
  setDeploymentMode,
  disabled
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.stepDeploymentModeTitle', {
      defaultMessage: 'Choose a deployment mode for security'
    }),
    status: disabled ? 'disabled' : undefined,
    children: disabled ? null : /*#__PURE__*/_react.default.createElement(DeploymentModeStepContent, {
      deploymentMode: deploymentMode,
      setDeploymentMode: setDeploymentMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    })
  };
};
exports.getSetDeploymentModeStep = getSetDeploymentModeStep;
const DeploymentModeStepContent = ({
  deploymentMode,
  setDeploymentMode
}) => {
  const onChangeCallback = (0, _react.useCallback)(v => {
    const value = v.split('_')[0];
    if (value === 'production' || value === 'quickstart') {
      setDeploymentMode(value);
    }
  }, [setDeploymentMode]);

  // radio id has to be unique so that the component works even if appears twice in DOM (Agents tab, Add agent flyout)
  const radioSuffix = (0, _react.useMemo)(() => Date.now(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.stepDeploymentModeDescriptionText",
    defaultMessage: "Fleet uses Transport Layer Security (TLS) to encrypt traffic between Elastic Agents and other components in the Elastic Stack. Choose a deployment mode to determine how you wish to handle certificates. Your selection will affect the Fleet Server setup command shown in a later step.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: [{
      id: `quickstart_${radioSuffix}`,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerSetup.deploymentModeQuickStartOption",
        defaultMessage: "{quickStart} \u2013 Fleet Server will generate a self-signed certificate. Subsequent agents must be enrolled using the --insecure flag. Not recommended for production use cases.",
        values: {
          quickStart: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 80,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.fleetServerSetup.quickStartText",
            defaultMessage: "Quick start",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 81,
              columnNumber: 23
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 15
        }
      })
    }, {
      id: `production_${radioSuffix}`,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerSetup.deploymentModeProductionOption",
        defaultMessage: "{production} \u2013 Provide your own certificates. This option will require agents to specify a cert key when enrolling with Fleet",
        values: {
          production: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 99,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.fleetServerSetup.productionText",
            defaultMessage: "Production",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 100,
              columnNumber: 23
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      })
    }],
    idSelected: `${deploymentMode}_${radioSuffix}`,
    onChange: onChangeCallback,
    name: `deploymentMode${radioSuffix}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
};