"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeriesColor = void 0;
exports.isHorizontalChart = isHorizontalChart;
var _visualization = require("./visualization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isHorizontalChart(layers) {
  return (0, _visualization.getDataLayers)(layers).every(l => l.isHorizontal);
}
const getSeriesColor = (layer, accessor) => {
  var _decorations$find;
  if ((0, _visualization.isDataLayer)(layer) && layer.splitAccessors || (0, _visualization.isAnnotationsLayer)(layer) || (0, _visualization.isReferenceLine)(layer)) {
    return null;
  }
  const decorations = layer === null || layer === void 0 ? void 0 : layer.decorations;
  return (decorations === null || decorations === void 0 ? void 0 : (_decorations$find = decorations.find(decorationConfig => decorationConfig.forAccessor === accessor)) === null || _decorations$find === void 0 ? void 0 : _decorations$find.color) || null;
};
exports.getSeriesColor = getSeriesColor;