"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdentifierControlForm = IdentifierControlForm;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _esqlTypes = require("@kbn/esql-types");
var _aggregation_functions = require("@kbn/esql-ast/src/definitions/generated/aggregation_functions");
var _esqlUtils = require("@kbn/esql-utils");
var _shared_form_components = require("./shared_form_components");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/esql/public/triggers/esql_controls/control_flyout/identifier_control_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IdentifierControlForm({
  variableType,
  variableName,
  initialState,
  queryString,
  cursorPosition,
  esqlVariables,
  currentApp,
  setControlState,
  search
}) {
  var _initialState$title, _initialState$width, _initialState$grow;
  const isMounted = (0, _useMountedState.default)();
  const [availableIdentifiersOptions, setAvailableIdentifiersOptions] = (0, _react.useState)([]);
  const [selectedIdentifiers, setSelectedIdentifiers] = (0, _react.useState)(initialState !== null && initialState !== void 0 && initialState.availableOptions ? initialState.availableOptions.map(option => {
    return {
      label: option,
      key: option,
      'data-test-subj': option
    };
  }) : []);
  const [label, setLabel] = (0, _react.useState)((_initialState$title = initialState === null || initialState === void 0 ? void 0 : initialState.title) !== null && _initialState$title !== void 0 ? _initialState$title : '');
  const [minimumWidth, setMinimumWidth] = (0, _react.useState)((_initialState$width = initialState === null || initialState === void 0 ? void 0 : initialState.width) !== null && _initialState$width !== void 0 ? _initialState$width : 'medium');
  const [grow, setGrow] = (0, _react.useState)((_initialState$grow = initialState === null || initialState === void 0 ? void 0 : initialState.grow) !== null && _initialState$grow !== void 0 ? _initialState$grow : false);
  (0, _react.useEffect)(function initAvailableIdentifiersOptions() {
    if (availableIdentifiersOptions.length > 0) return;
    if (variableType === _esqlTypes.ESQLVariableType.FIELDS) {
      const queryForFields = (0, _helpers.getQueryForFields)(queryString, cursorPosition);
      (0, _esqlUtils.getESQLQueryColumnsRaw)({
        esqlQuery: queryForFields,
        variables: esqlVariables,
        search
      }).then(columns => {
        if (isMounted()) {
          setAvailableIdentifiersOptions(columns.map(col => {
            return {
              label: col.name,
              key: col.name,
              'data-test-subj': col.name
            };
          }));
        }
      });
    }
    if (variableType === _esqlTypes.ESQLVariableType.FUNCTIONS) {
      const aggregatedFunctions = _aggregation_functions.aggFunctionDefinitions.map(func => {
        return {
          label: func.name,
          key: func.name,
          'data-test-subj': func.name
        };
      });
      setAvailableIdentifiersOptions(aggregatedFunctions);
    }
  }, [availableIdentifiersOptions.length, cursorPosition, isMounted, queryString, esqlVariables, search, variableType]);
  const onIdentifiersChange = (0, _react.useCallback)(selectedOptions => {
    setSelectedIdentifiers(selectedOptions);
  }, []);
  const onLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
  }, []);
  const onMinimumSizeChange = (0, _react.useCallback)(optionId => {
    if (optionId) {
      setMinimumWidth(optionId);
    }
  }, []);
  const onGrowChange = (0, _react.useCallback)(e => {
    setGrow(e.target.checked);
  }, []);
  const onCreateOption = (0, _react.useCallback)((searchValue, flattenedOptions = []) => {
    if (!searchValue.trim()) {
      return;
    }
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    const newOption = {
      label: searchValue,
      key: searchValue,
      'data-test-subj': searchValue
    };
    if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1) {
      setAvailableIdentifiersOptions(prev => [...prev, newOption]);
    }
    setSelectedIdentifiers(prevSelected => [...prevSelected, newOption]);
  }, []);
  (0, _react.useEffect)(() => {
    const availableOptions = selectedIdentifiers.map(value => value.label);
    // removes the double question mark from the variable name
    const variableNameWithoutQuestionmark = variableName.replace(/^\?+/, '');
    const state = {
      availableOptions,
      selectedOptions: [availableOptions[0]],
      width: minimumWidth,
      title: label || variableNameWithoutQuestionmark,
      variableName: variableNameWithoutQuestionmark,
      variableType,
      esqlQuery: queryString,
      controlType: _esqlTypes.EsqlControlType.STATIC_VALUES,
      grow
    };
    if (!(0, _lodash.isEqual)(state, initialState)) {
      setControlState(state);
    }
  }, [grow, initialState, label, minimumWidth, queryString, selectedIdentifiers, setControlState, variableName, variableType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.values.label', {
      defaultMessage: 'Values'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('esql.flyout.fieldsOptions.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    placeholder: _i18n.i18n.translate('esql.flyout.fieldsOptions.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    options: availableIdentifiersOptions,
    selectedOptions: selectedIdentifiers,
    onChange: onIdentifiersChange,
    onCreateOption: onCreateOption,
    "data-test-subj": "esqlIdentifiersOptions",
    fullWidth: true,
    compressed: true,
    isClearable: true,
    css: (0, _react2.css)`
            .euiFormControlLayoutIcons {
              align-items: flex-start;
              padding-block-start: 1ch;
            }
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlLabel, {
    label: label,
    onLabelChange: onLabelChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlWidth, {
    minimumWidth: minimumWidth,
    grow: grow,
    onMinimumSizeChange: onMinimumSizeChange,
    onGrowChange: onGrowChange
    // This property is not compatible with the unified search yet
    // we will hide this possibility for now
    ,
    hideFitToSpace: currentApp === 'discover',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }));
}