"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHoverItem = getHoverItem;
var _esqlAst = require("@kbn/esql-ast");
var _columns_retrieval_helpers = require("../shared/columns_retrieval_helpers");
var _helpers = require("./helpers");
var _get_policy_hover = require("./get_policy_hover");
var _get_function_signature_hover = require("./get_function_signature_hover");
var _get_query_for_fields = require("../shared/get_query_for_fields");
var _get_function_argument_hover = require("./get_function_argument_hover");
var _get_column_hover = require("./get_column_hover");
var _subqueries_helpers = require("../shared/subqueries_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getHoverItem(fullText, offset, callbacks) {
  var _callbacks$getVariabl;
  const correctedQuery = (0, _helpers.correctQuerySyntax)(fullText, offset);
  const {
    root
  } = (0, _esqlAst.parse)(correctedQuery);
  let containingFunction;
  let node;
  _esqlAst.Walker.walk(root, {
    visitFunction: fn => {
      if ((0, _esqlAst.within)(offset, fn)) node = fn;
      if (fn.subtype === 'variadic-call') {
        const parentheses = {
          left: fullText.indexOf('(', fn.location.min),
          right: fn.location.max
        };
        if (parentheses.left < offset && parentheses.right > offset) containingFunction = fn;
      }
    },
    visitSource: (source, parent, walker) => {
      if ((0, _esqlAst.within)(offset, source)) {
        node = source;
        walker.abort();
      }
    },
    visitSingleAstItem: _node => {
      // ignore identifiers because we don't want to choose them as the node type
      // instead of the function node (functions can have an "operator" child which is
      // usually an identifer representing the name of the function)
      if (_node.type !== 'identifier' && (0, _esqlAst.within)(offset, _node)) {
        node = _node;
      }
    }
  });
  const hoverContent = {
    contents: []
  };
  if (!node) {
    return hoverContent;
  }
  const {
    subQuery
  } = (0, _subqueries_helpers.findSubquery)(root, offset);
  const astForContext = subQuery !== null && subQuery !== void 0 ? subQuery : root;
  const {
    getColumnMap
  } = (0, _columns_retrieval_helpers.getColumnsByTypeRetriever)((0, _get_query_for_fields.getQueryForFields)(fullText, astForContext), fullText, callbacks);

  // ES|QL variables hover
  const variables = callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getVariabl = callbacks.getVariables) === null || _callbacks$getVariabl === void 0 ? void 0 : _callbacks$getVariabl.call(callbacks);
  const variablesContent = (0, _helpers.getVariablesHoverContent)(node, variables);
  if (variablesContent.length) {
    hoverContent.contents.push(...variablesContent);
  }

  // Function arguments hover
  if (containingFunction) {
    const argHints = await (0, _get_function_argument_hover.getFunctionArgumentHover)(containingFunction, offset);
    hoverContent.contents.push(...argHints);
  }

  // Function signature hover
  if (node.type === 'function') {
    const functionSignature = await (0, _get_function_signature_hover.getFunctionSignatureHover)(node, getColumnMap);
    hoverContent.contents.push(...functionSignature);
  }

  // Policy hover
  if (node.type === 'source' && node.sourceType === 'policy') {
    const source = node;
    const policyHoverInfo = await (0, _get_policy_hover.getPolicyHover)(source, callbacks);
    hoverContent.contents.push(...policyHoverInfo);
  }

  // Column hover
  if (node.type === 'column') {
    const columnHover = await (0, _get_column_hover.getColumnHover)(node, getColumnMap);
    hoverContent.contents.push(...columnHover);
  }
  return hoverContent;
}