"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.correctQuerySyntax = correctQuerySyntax;
exports.getVariablesHoverContent = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _ast = require("@kbn/esql-ast/src/definitions/utils/ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getVariablesHoverContent = (node, variables) => {
  const usedVariablesInNode = node ? _esqlAst.Walker.params(node).map(v => v.text.replace('?', '')) : [];
  const usedVariables = variables === null || variables === void 0 ? void 0 : variables.filter(v => usedVariablesInNode.includes(v.key));
  const hoverContents = [];
  if (usedVariables !== null && usedVariables !== void 0 && usedVariables.length) {
    usedVariables.forEach(variable => {
      hoverContents.push({
        value: `**${variable.key}**: ${variable.value}`
      });
    });
  }
  return hoverContents;
};

/**
 * Corrects the query syntax by closing any unclosed brackets and removing incomplete args.
 * @param offset
 * @param query
 * @returns
 */
exports.getVariablesHoverContent = getVariablesHoverContent;
function correctQuerySyntax(query, offset) {
  // Dispose any following commands after the current offset
  const nextPipeIndex = query.indexOf('|', offset);
  if (nextPipeIndex !== -1) {
    query = query.substring(0, nextPipeIndex);
  }

  // Close any pending to be closed bracket
  const bracketsToAppend = (0, _ast.getBracketsToClose)(query);
  query += bracketsToAppend.join('');

  // Replace partially written function arguments: ,) with )
  query = query.replace(/,\s*\)/g, ')');
  return query;
}