"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPolicyHover = getPolicyHover;
var _i18n = require("@kbn/i18n");
var _util = require("@kbn/esql-ast/src/commands_registry/commands/enrich/util");
var _hover_cache = require("./hover_cache");
var _resources_helpers = require("../shared/resources_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getPolicyHover(source, callbacks) {
  // Use policy name as cache key
  const cacheKey = source.name;
  const cached = (0, _hover_cache.fromCache)(cacheKey);
  if (cached) {
    return cached;
  }
  const result = [];
  const {
    getPolicyMetadata
  } = (0, _resources_helpers.getPolicyHelper)(callbacks);
  const policyMetadata = await getPolicyMetadata(source.name);
  if (policyMetadata) {
    result.push(...[{
      value: `${_i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.hover.policyIndexes', {
        defaultMessage: '**Indexes**'
      })}: ${policyMetadata.sourceIndices.join(', ')}`
    }, {
      value: `${_i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.hover.policyMatchingField', {
        defaultMessage: '**Matching field**'
      })}: ${policyMetadata.matchField}`
    }, {
      value: `${_i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.hover.policyEnrichedFields', {
        defaultMessage: '**Fields**'
      })}: ${policyMetadata.enrichFields.join(', ')}`
    }]);
  }
  if (!!source.prefix) {
    const mode = _util.ENRICH_MODES.find(({
      name
    }) => '_' + name === source.prefix.valueUnquoted.toLowerCase());
    if (mode) {
      result.push(...[{
        value: _util.modeDescription
      }, {
        value: `**${mode.name}**: ${mode.description}`
      }]);
    }
  }
  (0, _hover_cache.setToCache)(cacheKey, result);
  return result;
}