"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnHover = getColumnHover;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getColumnHover(node, getColumnMap) {
  const columnsMap = await getColumnMap();
  const columnData = columnsMap.get(node.name);
  if (columnData) {
    return [{
      value: `**${node.name}**: ${columnData.type}`
    }];
  }
  return [];
}