"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.limit = limit;
var _append = require("../pipeline/append");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Appends a `LIMIT` command to the ESQL composer pipeline.
 *
 * @param value The limit to apply.
 * @returns A `QueryPipeline` instance with the `LIMIT` command appended.
 */
function limit(value) {
  return (0, _append.append)({
    command: `LIMIT ${value}`
  });
}